
import time
import re
import datetime
from app import config
from lib.util import sameday, tz
from lib.mvc.widgets import truncateText
RE_AMOUNT = re.compile('^(?P<head>\\d+).?(?P<tail>\\d{1,2})?')
def parseTags(tags):
    
    tags = filter(lambda name: (len(name) > 0), map(unicode.strip, unicode(tags).split(',')))
    uniqueTags = []
    for tag in tags:
        if (tag not in uniqueTags):
            uniqueTags.append(tag)
    return uniqueTags
def parseAmount(amount):
    
    (match, parsed) = (RE_AMOUNT.match(amount), 0)
    if match:
        data = match.groupdict()
        parsed1 = (long(data['head']) * 100)
        parsed2 = (data['tail'] if data['tail'] else '0')
        return (parsed1 + ((long(parsed2) * 10) if (len(parsed2) < 2) else long(parsed2)))
    return None
def parseDescription(description):
    return description.strip()
def formatTimezone(tzInt):
    tzInt = -(tzInt)
    res = ('GMT%s%s:%s' % (('+' if (tzInt > 0) else '-'), str((abs(tzInt) / 3600)).zfill(2), str(((abs(tzInt) / 60) % 60)).zfill(2)))
    return res
def parseDate(string):
    
    return datetime.datetime.strptime(string, '%Y-%m-%d').date()
def formatDate(date):
    return date.isoformat()
def formatAmount(amount, format):
    
    res = (format % (str((amount / 100)), str((amount % 100)).zfill(2)))
    return res.strip()
def formatAmountTruncate(amount, format, width, maxChars=20, font='Nokia Sans Bold 20'):
    formatted = formatAmount(amount, format)
    s = formatted.split(' ')
    return truncateText(s[0], width, maxChars, font=font, end=(' %s' % s[1]))
def formatCurrency(currency):
    try:
        cdata = config.get('currencies')[currency]
        return ('%s %s' % (cdata[0], cdata[1]))
    except:
        return ('%s %s' % ('Custom currency', currency))
def formatDateSmart(date, format):
    if sameday(date, datetime.datetime.now(tz.local).date()):
        return 'Today'
    if sameday(date, (datetime.datetime.now(tz.local).date() - datetime.timedelta(1))):
        return 'Yesterday'
    else:
        return date.strftime(format)
def formatTimespan(timespan):
    if (timespan == 'all'):
        return 'All time'
    else:
        if (timespan == 'month'):
            return 'Total'
        else:
            return timespan.strftime('%B %Y')
