
import gtk, hildon
import config
from lib.mvc.view import View
from lib.mvc.widgets import *

class EdittagsView(View, ):
    def _init_(self):
        self.setWidget(newWindow(title='Edit tags'))
        parea = newPannableArea()
        vbox = newVBox()
        list = TagList()
        self.add(list, 'tag_list')
        parea.add_with_viewport(list)
        parea.connect('vertical-movement', list.paneMoved)
        header = newHBox(size_request=(-1, 56))
        header.pack_start(newLabel(text='Tags', alignment=(0.0, 0.5)), padding=15)
        header.pack_end(newLabel(text='Times used', name='edittags_header_count', alignment=(1.0, 0.5)), padding=30)
        vbox.pack_start(wrap(header, newEventBox(name='edittags_header')), fill=True, expand=False)
        vbox.pack_start(parea, fill=True, expand=True)
        self.getWidget().add(vbox)

class TagList(gtk.VBox, ):
    def __init__(self):
        gtk.VBox.__init__(self)
        self._selected = None
        self._callback = None
        self._entry = newEntry(name='edittags_tag_entry', size_request=(520, 55))
        self._entry.set_input_mode((gtk.HILDON_GTK_INPUT_MODE_DICTIONARY | gtk.HILDON_GTK_INPUT_MODE_FULL))
        self._button = newButton(label='Save', size_request=(195, 59), name='edittags_tag_button')
        self._moved = False
    def select(self, item):
        if self._selected:
            self._selected.renderProper()
        self._button.set_label('Save')
        self._button.connect('clicked', self.submit)
        self._entry.connect('activate', self.submit)
        item.renderSelected(self._entry, align(self._button, yalign=0.5))
        self._entry.set_text(item.getName())
        self._selected = item
        self._entry.grab_focus()
        self._entry.select_region(-1, -1)
    def submit(self, widget, data=None):
        if self._selected:
            name = self._selected.getName()
            (uuid, new_name) = (self._selected.getUuid(), unicode(self._entry.get_text()).strip())
            if ((len(new_name) > 0) and self._callback):
                if (new_name == name):
                    self._selected.renderProper()
                    self._selected = None
                else:
                    res = self._callback(uuid, new_name)
                    if res:
                        self._selected.setName(new_name)
                        self._selected.renderProper()
                        self._selected = None
    def register_submit(self, cb):
        self._callback = cb
    def clear(self):
        for child in self.get_children():
            self.remove(child)
            child.destroy()
    def add_row(self, uuid, name, count):
        self.pack_start(TagItem(self, uuid, name, count), expand=False, fill=False)
    def paneMoved(self, widget, direction, x, y, data=None):
        self._moved = True

class TagItem(gtk.EventBox, ):
    ROW_HEIGHT = 45
    SEL_HEIGHT = 70
    LPADDING = 40
    SEL_LPADDING = 25
    MPADDING = 10
    SEL_MPADDING = 25
    RPADDING = 35
    SEL_RPADDING = 25
    def __init__(self, list, uuid, name, count, **args):
        gtk.EventBox.__init__(self)
        self.set_name('edittags_tag_item')
        self._list = list
        self._uuid = uuid
        self._tagName = name
        self._tagCount = count
        self._hBox = None
        self.renderProper()
        self.connect('button-release-event', self.clicked)
    def _getName(self):
        lab = newLabel(size_request=(580, -1), alignment=(0.0, 0.5))
        lab.set_text(truncateText(self.getName(), 580, 100))
        return lab
    def _getCount(self):
        return newLabel(text=str(self.getCount()), alignment=(1.0, 0.5), size_request=(125, -1), name='edittags_tag_count')
    def renderProper(self):
        self.set_name('edittags_tag_item')
        self._render(self._getName(), self._getCount())
        self._proper = True
        self.show_all()
    def renderSelected(self, namePart, countPart):
        self.set_name('edittags_tag_selected')
        self._proper = False
        self._render(namePart, countPart, True)
        self.show_all()
    def _render(self, namePart, countPart, sel=False):
        if self._hBox:
            if (self._list._entry in self._hBox.get_children()):
                self._hBox.remove(self._list._entry)
            self._hBox.destroy()
        self._hBox = newHBox(size_request=(-1, (self.SEL_HEIGHT if sel else self.ROW_HEIGHT)))
        self._hBox.pack_start(newGap((self.SEL_LPADDING if sel else self.LPADDING)))
        self._name = namePart
        self._hBox.pack_start(self._name, expand=True, fill=True)
        self._hBox.pack_start(newGap((self.SEL_MPADDING if sel else self.MPADDING)))
        self._count = countPart
        self._hBox.pack_start(self._count)
        self._hBox.pack_start(newGap((self.SEL_RPADDING if sel else self.RPADDING)))
        self.add(self._hBox)
    def clicked(self, widget, event, data=None):
        if (self._proper and not(self._list._moved)):
            self._list.select(self)
        self._list._moved = False
    def getUuid(self):
        return self._uuid
    def getName(self):
        return self._tagName
    def setName(self, name):
        self._tagName = name
    def getCount(self):
        return self._tagCount
def newGap(px, **kwargs):
    return newLabel(size_request=(-1, px))
