
import logging
import gobject, gtk, hildon

class View(object, ):
    _application = None
    def __init__(self, name, ctrl, app):
        self._name = name
        self._ctrl = ctrl
        self._widget = None
        self._widgets = {}
        self._callbacks = filter(lambda name: (name[:3] == 'on_'), dir(self._ctrl))
        self._application = app
        logging.info('Initializing view "%s"', self._name)
        self._init_()
        assert (self._widget != None), ('Root widget must be defined in _init_ (view "%s")' % self._name)
        self._fix()
        self._ctrl.setView(self)
    def _init_(self):
        'TBD in children'
    def getName(self):
        return self._name
    def getCtrl(self):
        return self._ctrl
    def getApp(self):
        return self._application
    def setWidget(self, widget):
        
        widget.set_name(('%s_root' % self._name))
        self._widget = widget
    def getWidget(self, name=None):
        if not(name):
            return self._widget
        assert (name in self._widgets), ('Unrecognized widget "%s" requested' % name)
        return self._widgets[name]
    def removeWidget(self, name):
        if (name in self._widgets):
            del self._widgets[name]
    def getView(self, name, *args, **kwargs):
        return self.getApp().getView(name, *args, **kwargs)
    def viewLoaded(self, name):
        return self.getApp().viewLoaded(name)
    def show(self):
        logging.info(('Showing view "%s"' % self._name))
        self._widget.show_all()
    def add(self, widget, name=None, decorator=None, add=None, **kwargs):
        
        assert isinstance(widget, gobject.GObject), 'View can be registered only instances of gtk.Widget'
        if not(name):
            name = widget.get_name()
        name = name.lower()
        fullName = ('%s_%s' % (self.getName(), name))
        assert (name not in self._widgets), ('View name conflict, "%s" already added' % name)
        logging.debug('Adding widget "%s" to view "%s"', name, self._name)
        if isinstance(widget, gtk.Widget):
            widget.set_name(fullName)
        self._widgets[name] = widget
        if add:
            if decorator:
                widget = decorator(widget)
            assert isinstance(widget, gobject.GObject)
            self._widget.__getattribute__(add)(widget, **kwargs)
            logging.debug('Physically adding widget "%s" to view "%s"\'s widget root via method "%s"', name, self._name, add)
        return name
    def _getCallback(self, name):
        assert (name in self._callbacks), ('Requesting non existing callback "%s" in view "%s"' % (name, self.getName()))
        return self._ctrl.__getattribute__(name)
    def _fix(self):
        
        for signal in ['hide', 'show', 'realize', 'unrealize', 'destroy', 'delete-event']:
            methodName = ('on_%s' % signal.replace('-', '_'))
            if (methodName in self._callbacks):
                logging.debug('Connecting signal %s (%s) on view "%s" main widget.', signal, methodName, self._name)
                self._widget.connect(signal, self._getCallback(methodName))
        for name in self._widgets.keys():
            self._registerWidget(name)
        self._fixed = True
    def _registerWidget(self, name):
        prefix = ('on_%s_' % name)
        matches = filter(lambda name: name.startswith(prefix), self._callbacks)
        for methodName in matches:
            signal = methodName[len(prefix):].replace('_', '-')
            logging.debug('Widget %s:%s, connecting signal %s on %s', self._name, name, signal, methodName)
            self._widgets[name].connect(signal, self._getCallback(methodName))
