
import gtk
import config
from lib.mvc.view import View
from lib.mvc.widgets import *

class WelcomeView(View, ):
    def _init_(self):
        self.setWidget(newWindow(title='Welcome to Toshl'))
        switcher = newSwitcher()
        self.add(switcher, 'switcher', None, 'add')
        w1 = WelcomeScreen1()
        w2 = WelcomeScreen2()
        w3 = WelcomeScreen3()
        switcher.add_item('welcome1', w1)
        switcher.add_item('welcome2', w2)
        switcher.add_item('welcome3', w3)
        self.add(w1.getNextButton(), 'w1_next_button')
        self.add(w2.getPrevButton(), 'w2_prev_button')
        self.add(w2.getNextButton(), 'w2_next_button')
        self.add(w3.getPrevButton(), 'w3_prev_button')
        self.add(w3.getSkipBox(), 'skip_box')
        self.add(w3.getLoginButton(), 'login_button')
        self.add(w3.getRegisterButton(), 'register_button')
    def switch(self, i):
        assert (i in (1, 2, 3))
        self.getWidget().set_name(('welcome_root_%d' % i))
        self.getWidget('switcher').switch(('welcome%d' % i), True)
        self.getWidget().ensure_style()

class WelcomeScreen(gtk.Fixed, ):
    WELCOME_ICON = 'data/img/ToshlWelcomeIcon.png'
    SIDE_PADDING = 35
    BUTTON_WIDTH = 220
    BUTTON_HEIGHT = 70
    BUTTON_LINE = 345
    ICON_LINE = 30
    TITLE_LINE = 35
    TITLE_PADDING = 105
    DESC_LINE = 100
    DESC_WIDTH = 350
    INTRO_GAP = 20
    _num = 0
    _back = True
    _next = True
    _descTitle = ''
    _descContent = ''
    _descIntro = None
    def __init__(self):
        gtk.Fixed.__init__(self)
        if self._back:
            self._backButton = newButton(label='Back', size_request=(self.BUTTON_WIDTH, self.BUTTON_HEIGHT))
            self.put(self._backButton, self.SIDE_PADDING, self.BUTTON_LINE)
        if self._next:
            self._nextButton = newButton(label='Next', size_request=(self.BUTTON_WIDTH, self.BUTTON_HEIGHT))
            self.put(self._nextButton, ((800 - self.BUTTON_WIDTH) - self.SIDE_PADDING), self.BUTTON_LINE)
        self._icon = newImage(from_file=config.joinRoot(self.WELCOME_ICON))
        self.put(self._icon, self.SIDE_PADDING, self.ICON_LINE)
        self.put(newLabel(name='welcome_title', text='Welcome to Toshl'), self.TITLE_PADDING, self.TITLE_LINE)
        self._description = newLabel(markup=self._content, line_wrap=True, name='welcome_desc', size_request=(self.DESC_WIDTH, -1))
        self.put(self._description, self.SIDE_PADDING, self.DESC_LINE)
        self._init()
    def _init(self):
        pass
    def getPrevButton(self):
        if self._back:
            return self._backButton
        return None
    def getNextButton(self):
        if self._next:
            return self._nextButton
        return None

class WelcomeScreen1(WelcomeScreen, ):
    _num = 1
    _back = False
    _content = "Toshl is an app that helps you track your expenses. It's easy to add expenses and sort them using tags, so you will know just when and what you have spent for.\n    \n<b>1. Add an expense</b>\nFirst enter the price, then the tags which describe the expense. The ones you use most can be added just by tapping them."

class WelcomeScreen2(WelcomeScreen, ):
    _num = 2
    _content = '<b>2. Categorise expenses by tags</b>\nThe tags you add to expense will help you sort your expenses. You can even assign more than one tag to an expense.'

class WelcomeScreen3(WelcomeScreen, ):
    _num = 3
    _next = False
    _content = '<b>3. Sync with Toshl.com</b>\nToshl has a companion website with which you can sync your expenses. It offers beautiful graphs, export to popular formats, backup of your data and expense reports by email. Your data is kept secure and private.'
    def _init(self):
        self._skipBox = wrap(newLabel(text='Skip'), newEventBox(name='welcome_skip'))
        self.put(self._skipBox, ((800 - self.SIDE_PADDING) - 30), (self.BUTTON_LINE + 30))
        BUTTON_WIDTH = 310
        LEFT_LINE = ((800 - BUTTON_WIDTH) - self.SIDE_PADDING)
        TOP1 = 90
        TOP2 = 210
        BUTTON_TOP = 30
        self.put(newLabel(text="I'm new to Toshl", name='welcome_desc2'), LEFT_LINE, TOP1)
        self._registerButton = newFingerButton(label='Register', size_request=(BUTTON_WIDTH, self.BUTTON_HEIGHT))
        self.put(self._registerButton, LEFT_LINE, (TOP1 + BUTTON_TOP))
        self.put(newLabel(text='I already have an account', name='welcome_desc2'), LEFT_LINE, TOP2)
        self._loginButton = newFingerButton(label='Log in', size_request=(BUTTON_WIDTH, self.BUTTON_HEIGHT))
        self.put(self._loginButton, LEFT_LINE, (TOP2 + BUTTON_TOP))
    def getSkipBox(self):
        return self._skipBox
    def getRegisterButton(self):
        return self._registerButton
    def getLoginButton(self):
        return self._loginButton
