
import config
from lib.maemo.context import Context

class AppContext(Context, ):
    AUTH_SRC_WELCOME = 0
    AUTH_SRC_SETTINGS = 1
    def __init__(self, app):
        Context.__init__(self, 'com.thirdframestudios.toshl.app')
        self._app = app
        self._in_sync = False
        self._auth_src = None
    def isInSync(self):
        return self._in_sync
    def getApp(self):
        return self._app
    def cb_register(self, token, secret):
        self.getApp().getStore().updateAccount(token=token, token_secret=secret)
        self.sysNote('Toshl authorization succeded')
        self.getApp().hideLoading(('settings' if (self._auth_src == self.AUTH_SRC_SETTINGS) else 'welcome'))
        self.getApp().getView('main').showSync()
        if (self._auth_src == self.AUTH_SRC_SETTINGS):
            self.getApp().popView('settings')
        else:
            if (self._auth_src == self.AUTH_SRC_WELCOME):
                self.getApp().popView('welcome_root_3', True)
        if (self.getApp().getStore().getPref('initial_sync') != 0):
            self.synchronize()
        self._auth_src = None
    def cb_old_daemon(self):
        self.fire('com.thirdframestudios.toshl.daemon.app_on')
    def cb_register_failed(self):
        self.sysNote('Toshl authorization failed')
        self.getApp().hideLoading(('settings' if (self._auth_src == self.AUTH_SRC_SETTINGS) else 'welcome'))
        self._auth_src = None
    def cb_register_browser(self):
        self.getApp().hideLoading(('settings' if (self._auth_src == self.AUTH_SRC_SETTINGS) else 'welcome'))
    def cb_sync_finished(self, success=False):
        if self._in_sync:
            self._in_sync = False
            self.sysNote('Synchronization done')
            self.getApp().getStore().initCon()
            self.getApp().getView('area').getCtrl().fill()
            self.getApp().getView('loader').getCtrl().stop()
            self.getApp().popView('loader')
            self.getApp().getView('settings').setSyncLabel(self.getApp().getAccount().getLastSync())
    def cb_sync_aborted(self):
        if self._in_sync:
            self._in_sync = False
            self.sysNote('Synchronization aborted')
            self.getApp().getStore().initCon()
            self.getApp().getView('loader').getCtrl().stop()
            self.getApp().popView('loader')
    def cb_sync_failed(self, oauth=False):
        if self._in_sync:
            self._in_sync = False
            if oauth:
                self.sysNote('Authorization Error. Please, log in again.')
                self.getApp().getView('main').hideSync()
            else:
                self.sysNote('Synchronization failed')
            self.getApp().getStore().initCon()
            self.getApp().getView('loader').getCtrl().stop()
            self.getApp().popView('loader')
    def cb_sync_happening(self):
        self.getApp().getStore().close()
        self.getApp().pushView('loader')
        self._in_sync = True
    def cb_top_application(self, data=None):
        self.getApp().getView('main').getWidget().show()
    def authenticate(self, register, source):
        self._auth_src = source
        self.getApp().showLoading(('settings' if (source == self.AUTH_SRC_SETTINGS) else 'welcome'))
        if (self.getConnectionUp() or (self.getImei() == '0000000000')):
            self.fire('com.thirdframestudios.toshl.daemon.oauth_start', register)
        else:
            self.fire('com.thirdframestudios.toshl.daemon.oauth_try', register)
    def synchronize(self):
        if not(self._in_sync):
            if (self.getConnectionUp() or (self.getImei() == '0000000000')):
                self.getApp().getStore().close()
                self.getApp().pushView('loader')
                self.fire('com.thirdframestudios.toshl.daemon.sync', True)
                self._in_sync = True
            else:
                self.fire('com.thirdframestudios.toshl.daemon.sync_try')
    def abort(self):
        if self._in_sync:
            self.fire('com.thirdframestudios.toshl.daemon.abort')
        else:
            self.getApp().popView('loader')
    def app_on(self):
        self.fire('com.thirdframestudios.toshl.daemon.app_on', config.get('version'))
    def app_off(self, when=2, thingsChanged=False):
        self.fire('com.thirdframestudios.toshl.daemon.app_off', when, thingsChanged)
