
import logging
import osso, dbus
import gtk
import gconf
from lib.error import Error

class Context(object, ):
    
    def __init__(self, name, version='0.1'):
        self._context = osso.Context(name, version, False)
        self._name = name
        self._obj = self._nameToObj(name)
        self._rpc = osso.Rpc(self._context)
        self._app = osso.Application(self._context)
        self._sys = osso.SystemNote(self._context)
        self._bus = None
        self._rpc.set_rpc_callback(self._name, self._obj, self._name, self.receive)
    def main(self):
        gtk.gdk.threads_init()
        logging.info('Context %s in main', self._name)
        gtk.main()
    def destroy(self):
        logging.info('Destroying context.')
        gtk.main_quit()
    def call(self, fullMethod, *args):
        return self._abstractCall(fullMethod, args, async=False, wait=True)
    def fire(self, fullMethod, *args):
        return self._abstractCall(fullMethod, args, async=False, wait=False)
    def send(self, fullMethod, callback=None, data=None, *args):
        return self._abstractCall(fullMethod, args, async=True, callback=callback, data=data)
    def receive(self, interface, method, args=(), user_data=None):
        
        logging.info('RPC: Context received call for method %s', method)
        name = ('cb_%s' % method)
        if (name in dir(self)):
            try:
                return self.__getattribute__(name)(*args)
            except Exception, e:
                logging.error('RPC: Context method raised error %s', str(e))
        else:
            logging.error('RPC: Context failed to recognize method %s', method)
    def _abstractCall(self, fullMethod, args, async=False, wait=False, callback=None, data=None):
        if ('.' not in fullMethod):
            raise ContextError('RPC: Calling method "%s" failed. Method name must be full (with context)', fullMethod)
        logging.info('RPC: Calling method %s', fullMethod)
        split = fullMethod.split('.')
        (context, method) = ('.'.join(split[:-1]), split[-1])
        obj = self._nameToObj(context)
        if not(async):
            return self._rpc.rpc_run(context, obj, context, method, args, wait_reply=wait)
        else:
            return self._rpc.rpc_async_run(context, obj, context, method, callback, data, args)
    def _nameToObj(self, name):
        
        return ('/' + '/'.join(name.split('.')))
    def getBus(self):
        if not(self._bus):
            self._bus = dbus.SystemBus()
        return self._bus
    def getConf(self):
        return gconf.client_get_default()
    def openBrowser(self, url, *args):
        self.call('com.nokia.osso_browser.load_url', url, *args)
    def getImei(self):
        bus = self.getBus()
        try:
            iface = dbus.Interface(bus.get_object('com.nokia.phone.SIM', '/com/nokia/phone/SIM/security'), 'Phone.Sim.Security')
            (imei, obs) = iface.get_imei()
        except dbus.DBusException:
            return '0000000000'
        return str(imei)
    def getConnection(self):
        bus = self.getBus()
        try:
            iface = dbus.Interface(bus.get_object('com.nokia.icd', '/com/nokia/icd'), 'com.nokia.icd')
            result = iface.get_statistics()
            return str(result[0])
        except Exception, e:
            logging.error('Failed to get connection statistics: %s', e)
            return None
    def getConnectionUp(self):
        bus = self.getBus()
        try:
            iface = dbus.Interface(bus.get_object('com.nokia.icd', '/com/nokia/icd'), 'com.nokia.icd')
            result = iface.get_state()
            return (int(result) == 1)
        except Exception, e:
            logging.error('Failed to get connection state: %s', e)
            return False
    def selectConnectionDialog(self):
        bus = self.getBus()
        try:
            iface = dbus.Interface(bus.get_object('com.nokia.icd_ui', '/com/nokia/icd_ui'), 'com.nokia.icd_ui')
            iface.show_conn_dlg(False)
            return True
        except Exception, e:
            logging.error('Failed to show connection dialog: %s', e)
        return False
    def getConnectionType(self):
        con = self.getConnection()
        if con:
            try:
                name = ('/system/osso/connectivity/IAP/%s/type' % gconf.escape_key(con, len(con)))
                type = self.getConf().get_string(name)
                logging.error('Type: %s', type)
                if (type[:4] == 'WLAN'):
                    return 'wlan'
                else:
                    return 'gprs'
            except Exception:
                return None
        return None
    def appTop(self, appName):
        logging.info('Cntext topping app %s', appName)
        self._app.application_top(appName)
    def sysNote(self, text):
        logging.info('Context system note: %s', text)
        self._sys.system_note_infoprint(text)

class ContextError(Error, ):
    pass
