
import logging
import gobject
import time
from lib.maemo.context import Context
from lib.util.oauth import Authentication
from lib.sync import Sync, SyncError, AuthorizationError
import format
import store
import config

class Toshl(Context, ):
    
    TOSHL_URL = 'https://toshl.com/'
    API_URL = 'https://toshl.com/api/1.0/'
    OAUTH_URL = 'https://toshl.com/oauth/%s/'
    OAUTH_CONSUMER_KEY = '17C317FF-4DF9-4002-AE8E-2B9A39FF25E9'
    OAUTH_CONSUMER_SECRET = 'C937B300-AF5F-4DC0-AE9B-30A00B07E4DE'
    SYNC_SETTINGS = 0
    SYNC_TAGS_POST = 1
    SYNC_TAGS_GET = 2
    SYNC_EXPENSES_POST = 3
    SYNC_EXPENSES_GET = 4
    SYNC_ERROR = 5
    SYNC_DELAY = 60000
    PING_DELAY = 30000
    CON_ITERATIONS = 30
    CON_DELAY = 4000
    INIT_TRIES = 5
    def __init__(self):
        Context.__init__(self, 'com.thirdframestudios.toshl.daemon')
        self._oauth = None
        self._sync = None
        self._syncAborted = False
        self._store = None
        self._tags = [0, 0]
        self._app_on = False
        self._expenses = [0, 0]
        self._postedTagsUuids = []
        self._postedExpensesUuids = []
        self._syncManual = False
        self._syncDelay = None
        self._conSelected = None
        self._initSync = False
        gobject.timeout_add(self.PING_DELAY, self.ping_alive)
    def initStore(self):
        
        if not(self._store):
            logging.info('Initializing store with sqlite file %s', config.getDbFile())
            self._store = store.Store(config.getDbFile(), config.getSchemeFile())
    def closeStore(self):
        logging.info('Closing store')
        if self._store:
            self._store.close()
        self._store = None
    def cb_abort(self):
        self._syncAborted = True
        self.fire('com.thirdframestudios.toshl.app.sync_aborted')
        self.closeStore()
        self._sync = None
    def cb_browser_response(self, url):
        if self._oauth:
            success = True
            try:
                self._oauth.authorized(url)
            except Exception, e:
                logging.error('Authorized failed: %s', e)
                success = False
            if success:
                (token, secret) = (None, None)
                try:
                    self._oauth.token()
                    (token, secret) = self._oauth.getAccessToken()
                except Exception, e:
                    logging.error('Token failed: %s', e)
                    success = False
            if success:
                try:
                    self.fire('com.thirdframestudios.toshl.app.register', token, secret)
                except Exception, e:
                    logging.error('Failed to inform app of successful registrations: %s', e)
                    success = False
            if not(success):
                self.fire('com.thirdframestudios.toshl.app.register_failed')
            self._oauth.closeCurl()
            self._oauth = None
            self.appTop('com.thirdframestudios.toshl.app')
    def cb_oauth_start(self, register=False):
        logging.info('OAuth start')
        self._oauth = self._newAuthentication()
        tries = 0
        try:
            while True:
                try:
                    tries += 1
                    self._oauth.initialize()
                    break
                except Exception, e:
                    time.sleep(3)
                    if (tries >= self.INIT_TRIES):
                        raise e
        except Exception, e:
            self._oauth.closeCurl()
            self.fire('com.thirdframestudios.toshl.app.register_failed')
            logging.error('Initialization failed: %s', e)
        try:
            self._oauth.authorize(self.openBrowser, self.getImei(), register=register)
            self.fire('com.thirdframestudios.toshl.app.register_browser')
        except Exception, e:
            self._oauth.closeCurl()
            self.fire('com.thirdframestudios.toshl.app.register_failed')
            logging.error('Authorization failed: %s', e)
    def cb_sync_try(self):
        self.dotry(True, skip=True)
    def cb_oauth_try(self, register=False):
        self.dotry(False, register, skip=True)
    def dotry(self, sync=True, register=False, skip=False):
        logging.debug(('Trying sync' if sync else 'Trying login'))
        if ((self._conSelected != None) and not(skip)):
            if (self._conSelected > self.CON_ITERATIONS):
                self._conSelected = None
                return False
            if not(self.getConnectionUp()):
                self._conSelected += 1
                return True
            else:
                self._conSelected = None
                if sync:
                    self.fire('com.thirdframestudios.toshl.app.sync_happening')
                    gobject.idle_add(self.cb_sync, True)
                else:
                    if not(self._oauth):
                        gobject.idle_add(self.cb_oauth_start, register)
                return False
        else:
            self.selectConnectionDialog()
            self._conSelected = 1
            gobject.timeout_add(self.CON_DELAY, self.dotry, sync, register)
            return False
    def cb_sync(self, manual=False):
        logging.info('Starting SYNC')
        self._syncManual = manual
        if not(self._store):
            self.initStore()
            self._store.repair()
        if not(self._sync):
            account = self._store.getAccount()
            self._sync = self._newSync(account.get('token'), account.get('token_secret'))
            self._sync.initCurl()
        self._syncAborted = False
        self._tags = [0, 0]
        self._expenses = [0, 0]
        self._postedTagsUuids = []
        self._postedExpensesUuids = []
        self._syncProceed(self.SYNC_SETTINGS)
    def cb_app_on(self, version=None):
        if (version != config.get('version')):
            if not(self._sync):
                self.fire('com.thirdframestudios.toshl.app.old_daemon')
                self.destroy()
        self._app_on = True
        if self._sync:
            self._syncManual = True
            self.fire('com.thirdframestudios.toshl.app.sync_happening')
        if self._syncDelay:
            gobject.source_remove(self._syncDelay)
    def cb_app_off(self, sync=2, thingsChanged=False):
        self._app_on = False
        if thingsChanged:
            if (sync == 2):
                logging.info('Will not sync, user does not want to.')
                self.destroy()
            else:
                logging.info('Scheduling sync')
                self._syncDelay = gobject.timeout_add(self.SYNC_DELAY, self.sync_after_delay, sync)
        else:
            logging.info('Sync not needed. Nothing changed.')
            self.destroy()
    def sync_after_delay(self, sync):
        logging.info('Syncing after app close')
        if (sync == 0):
            self.cb_sync()
        else:
            if (sync == 1):
                logging.info("Checking if we're on wifi, should sync ")
                typ = self.getConnectionType()
                if (typ == 'wlan'):
                    logging.info('We are on wifi.')
                    self.cb_sync()
                else:
                    logging.info('We are not on wifi, not syncing.')
        self._syncDelay = None
        return False
    def ping_alive(self):
        
        logging.debug('Check alive')
        if (self._app_on or (self._sync != None) or (self._syncDelay != None)):
            return True
        else:
            self.destroy()
            return False
    def _syncCheckAbort(self):
        if self._syncAborted:
            self._syncError(True)
            return True
        return False
    def _syncProceed(self, wha):
        if not(self._syncCheckAbort()):
            if (wha == self.SYNC_SETTINGS):
                self._syncSettings()
            else:
                if (wha == self.SYNC_TAGS_POST):
                    self._syncTagsPost()
                else:
                    if (wha == self.SYNC_TAGS_GET):
                        self._syncTagsGetOne()
                    else:
                        if (wha == self.SYNC_EXPENSES_POST):
                            self._syncExpensesPost()
                        else:
                            if (wha == self.SYNC_EXPENSES_GET):
                                self._syncExpensesGetOne()
                            else:
                                self._syncError(False)
    def _syncError(self, aborted=False, oauth=False):
        if aborted:
            if self._syncManual:
                self.fire('com.thirdframestudios.toshl.app.sync_aborted')
        else:
            if oauth:
                self._store.updateAccount(token='', token_secret='')
            if self._syncManual:
                self.fire('com.thirdframestudios.toshl.app.sync_failed', oauth)
        self.closeStore()
        self._sync.closeCurl()
        self._sync = None
    def _syncFinish(self):
        self._store.repair()
        self._store.updateAccount(last_sync=self._store.utcUnix())
        self._store.setPref('initial_sync', 0)
        self.closeStore()
        logging.info('SYNC stats // Tags U%d D%d // Expenses U%d D%d', *(self._tags + self._expenses))
        if self._syncManual:
            self.fire('com.thirdframestudios.toshl.app.sync_finished')
        self._sync.closeCurl()
        self._sync = None
    def _syncSettings(self):
        self._initSync = False
        account = self._store.getAccount()
        self._sync.requestSettings(self.API_URL, account.get('currency_default'), account.get('language'), format.formatTimezone(account.get('timezone')), config.get('version'), bool(self._store.getPref('initial_sync')), self.cb_syncSettings)
    def cb_syncSettings(self, result=None):
        if not(self._syncCheckAbort()):
            if isinstance(result, AuthorizationError):
                self._syncError(False, oauth=True)
            else:
                if not(isinstance(result, SyncError)):
                    try:
                        pro = result['pro']
                        email = result['email']
                        if ('initial_sync' in result.keys()):
                            if (result['initial_sync'] == True):
                                self._initSync = True
                        self._store.updateAccount(pro=pro, email=email)
                        self._syncProceed(self.SYNC_TAGS_POST)
                    except Exception, e:
                        logging.error('Improper response for settings: %s', result)
                        self._syncError(False)
                else:
                    self._syncError(False)
    def _syncTagsPost(self):
        cSent = 0
        (data, uuids) = ([], [])
        tags = self._store.selectTagsForSync(self._initSync)
        for tag in tags:
            data.append({'uuid': tag['uuid'], 'name': tag['name'], 'date_modified': tag['date_modified'], 'deleted': tag['deleted']})
            uuids.append(tag['uuid'])
            cSent += 1
        del tags
        if True:
            self._postedTagsUuids = uuids
            self._tags[0] = cSent
            self._sync.postTags(self.API_URL, data, cb=self.cb_syncTagsPost)
        else:
            self._syncProceed(self.SYNC_TAGS_GET)
    def cb_syncTagsPost(self, result=None):
        if not(self._syncCheckAbort()):
            if not(isinstance(result, SyncError)):
                try:
                    logging.info('Tags posted')
                    self._store.updateByUuids('tag', self._postedTagsUuids, sync=True)
                    self._syncProceed(self.SYNC_TAGS_GET)
                except Exception, e:
                    logging.error('Error when getting response for posting tags: %s', e)
                    self._syncError(False)
            else:
                self._syncError(False)
    def cb_syncTagsGetOne(self, result=None):
        if not(self._syncCheckAbort()):
            next = False
            if ((type(result) == list) and (len(result) > 0)):
                try:
                    left = result[0]['left']
                    next = True
                except Exception:
                    pass
                for data in result:
                    try:
                        tag = self._store.getByUuid('tag', data['uuid'])
                        update = {'name': data['name'], 'date_modified': data['date_modified'], 'deleted': data['deleted'], 'sync': True}
                        if not(tag):
                            self._store.insertTag(uuid=data['uuid'], **update)
                        else:
                            self._store.updateTag(data['uuid'], **update)
                        self._tags[1] = (self._tags[1] + 1)
                    except Exception, e:
                        logging.error('Error inserting tag, corrupted data? Data: %s, Error: %s', data, e)
                        return self._syncError(False)
            if next:
                logging.info('Going to syncTagsGet once more')
                self._syncProceed(self.SYNC_TAGS_GET)
            else:
                logging.info('Tags receive finished.')
                self._syncProceed(self.SYNC_EXPENSES_POST)
    def _syncTagsGetOne(self):
        self._sync.requestTags(self.API_URL, self.cb_syncTagsGetOne)
    def _syncExpensesPost(self):
        cSent = 0
        (data, uuids) = ([], [])
        expenses = self._store.selectExpensesForSync(self._initSync)
        for expense in expenses:
            tags = self._store.getValues(self._store.selectTagsByExpense(expense['uuid']), 'uuid')
            data.append({'uuid': expense['uuid'], 'amount': expense['amount'], 'currency': expense['currency'], 'description': expense['description'], 'date': expense['date'], 'date_modified': expense['date_modified'], 'deleted': expense['deleted'], 'tags': tags})
            uuids.append(expense['uuid'])
            cSent += 1
        del expenses
        if self._syncAborted:
            return
        if (len(data) > 0):
            self._postedExpensesUuids = uuids
            self._expenses[0] = cSent
            self._sync.postExpenses(self.API_URL, data, cb=self.cb_syncExpensesPost)
        else:
            self._syncProceed(self.SYNC_EXPENSES_GET)
    def cb_syncExpensesPost(self, result=None):
        if not(self._syncCheckAbort()):
            if not(isinstance(result, SyncError)):
                try:
                    logging.info('Expenses posted')
                    self._store.updateByUuids('expense', self._postedExpensesUuids, sync=True)
                    self._syncProceed(self.SYNC_EXPENSES_GET)
                except Exception, e:
                    logging.error('Error when getting response for posting expenses: %s', e)
                    self._syncError(False)
            else:
                self._syncError(False)
    def _syncExpensesGetOne(self):
        self._sync.requestExpenses(self.API_URL, cb=self.cb_syncExpensesGetOne)
    def cb_syncExpensesGetOne(self, result=None):
        if not(self._syncCheckAbort()):
            next = False
            if ((type(result) == list) and (len(result) > 0)):
                try:
                    left = result[0]['left']
                    next = True
                except Exception:
                    pass
                for data in result:
                    try:
                        expense = self._store.getByUuid('expense', data['uuid'])
                        update = {'amount': data['amount'], 'description': data['description'], 'date': data['date'], 'currency': data['currency'], 'date_modified': data['date_modified'], 'deleted': data['deleted']}
                        if not(expense):
                            self._store.insertExpense(uuid=data['uuid'], **update)
                        else:
                            self._store.updateExpense(data['uuid'], **update)
                            self._store.removeExpenseToTagByExpense(data['uuid'])
                        tags = data['tags']
                        self._store.insertExpenseToTag(data['uuid'], data['tags'])
                        self._expenses[1] = (self._expenses[1] + 1)
                    except Exception, e:
                        logging.error('Error inserting expense, corrupted data? Data: %s, Error: %s', data, e)
                        return self._syncError(False)
            if next:
                logging.info('Going to syncExpensesGet once more')
                self._syncProceed(self.SYNC_EXPENSES_GET)
            else:
                logging.info('Expense receive finished.')
                self._syncFinish()
    def _newAuthentication(self):
        return Authentication((self.OAUTH_URL % 'initiate'), (self.OAUTH_URL % 'authorize'), (self.OAUTH_URL % 'token'), 'toshl://ok', 'toshl://error', self.OAUTH_CONSUMER_KEY, self.OAUTH_CONSUMER_SECRET)
    def _newSync(self, token, secret):
        return Sync(token, secret, self.OAUTH_CONSUMER_KEY, self.OAUTH_CONSUMER_SECRET)
