
import logging
import gobject, gtk
import format
from lib.mvc.view import View
from lib.mvc.widgets import *

class ExpenseView(View, ):
    _sections = []
    def _init_(self):
        self._sections = {}
        parea = newPannableArea(size_request=(475, -1), orientation=PannableArea.ORIENT_VERT)
        parea.set_property('hscrollbar-policy', gtk.POLICY_NEVER)
        self.setWidget(parea)
        hbox = newHBox()
        self.add(newVBox(False, 0), 'section_space')
        hbox.pack_start(self.getWidget('section_space'))
        hbox.pack_start(newLabel(size_request=(10, -1)))
        self.getWidget().add_with_viewport(hbox)
    def appendSection(self, typ, id, title, pos=None):
        index = len(self._sections)
        section = ExpenseSection(id, title, typ)
        self._sections[id] = section
        self.getWidget('section_space').pack_start(section, expand=False, fill=False)
        if (pos != None):
            self.getWidget('section_space').reorder_child(section, pos)
    def getSection(self, id):
        try:
            return self._sections[id]
        except Exception:
            return None
    def mapSections(self, cb):
        return map(cb, self._sections.values())
    def removeSection(self, id):
        self._sections[id].destroy()
        del self._sections[id]
    def clear(self):
        self._sections = {}
        space = self.getWidget('section_space')
        for child in space.get_children():
            space.remove(child)

class ExpenseSection(gtk.VBox, ):
    TYPE_TIMELINE = 0
    TYPE_TAGS = 1
    LEFT_PAD = 15
    RIGHT_PAD = 15
    TITLE_HEIGHT = 40
    SECTION_PAD = [10, 10]
    def __init__(self, id, title, typ):
        gtk.VBox.__init__(self, False, 0)
        self._id = id
        self._type = typ
        self._sum = 0L
        self._title = newLabel(text=title, alignment=(0, 0.5), size_request=(-1, self.TITLE_HEIGHT), padding=(self.LEFT_PAD, 0))
        titleBox = newEventBox(name=('expense_section_title_%s' % ('red' if (self._type == self.TYPE_TAGS) else 'normal')))
        titleBox.add(self._title)
        self.pack_start(titleBox, fill=True, expand=False)
        if (self._type == self.TYPE_TIMELINE):
            separator = wrap(newLabel(size_request=(-1, 2)), newEventBox(name='expense_section_separator'))
            self.pack_start(separator, False, False)
        self._tree = makeNew(ExpenseTreeView, id, name='expense_section')
        self.pack_start(self._tree, False, False)
        if (self._type == self.TYPE_TAGS):
            self._summer = newLabel(text='0.0', alignment=(1.0, 0.5), name='expense_section_summer_small')
            summerBox = newEventBox(name=('expense_section_summer_%s' % ('red' if (self._type == self.TYPE_TIMELINE) else 'normal')))
            hbox = newHBox()
            self._totalLabel = newLabel('Total:', alignment=(0.0, 0.5))
            hbox.pack_start(self._totalLabel)
            hbox.pack_end(self._summer)
            summerBox.add(hbox)
            self.pack_start(pad(summerBox, left=self.LEFT_PAD, right=10, top=5), False, False)
        self.pack_start(newLabel(size_request=(-1, self.SECTION_PAD[self._type])), False, False)
    def setSortOrder(self, amount=True):
        if amount:
            self.getStore().set_sort_column_id(6, gtk.SORT_DESCENDING)
        else:
            self.getStore().set_sort_column_id(7, gtk.SORT_DESCENDING)
    def getId(self):
        return self._id
    def unselectAll(self):
        self._tree.get_selection().unselect_all()
    def getTreeView(self):
        return self._tree
    def getStore(self):
        return self._tree.getStore()
    def addRow(self, uuid, text, amount, amountInt, date, insert=None):
        self._sum += amountInt
        row = (uuid, text, (amount + ' '), 1.0, 1000, '  ', long(amountInt), date)
        if (insert != None):
            return self.getStore().insert(insert, row)
        return self.getStore().append(row)
    def removeRow(self, iter):
        store = self.getTreeView().getStore()
        if store.iter_is_valid(iter):
            am = store.getAmountInteger(iter)
            self._tree.getStore().remove(iter)
            return am
        return 0
    def getIndex(self):
        return self._index
    def selectIter(self, iter):
        if self._tree.getStore().iter_is_valid(iter):
            self._tree.get_selection().select_iter(iter)
        else:
            logging.error('Iter not valid')
    def selectFirst(self):
        model = self.getStore()
        iter = model.get_iter_first()
        self.selectIter(iter)
        uuid = model.getUuid(iter)
        return (iter, uuid)
    def updateSummer(self, form):
        self._summer.set_text(format.formatAmount(self._sum, form))
    def setTotalLabel(self, label):
        self._totalLabel.set_text(label)
    def addToSum(self, am):
        self._sum += am
    def getSum(self):
        return self._sum

class ExpenseTreeView(gtk.TreeView, ):
    def __init__(self, id):
        gtk.TreeView.__init__(self)
        self._store = ExpenseStore(id)
        self.set_model(self._store)
        cr = gtk.CellRendererText()
        cr2 = gtk.CellRendererText()
        cr3 = gtk.CellRendererText()
        self._col = gtk.TreeViewColumn()
        self._col.pack_start(cr, True)
        col2 = gtk.TreeViewColumn()
        cr2.set_property('width', 305)
        col2.pack_start(cr2, True)
        col3 = gtk.TreeViewColumn()
        cr3.set_property('width', 140)
        cr3.set_property('height', 41)
        col3.pack_start(cr3, True)
        self.append_column(self._col)
        self.append_column(col2)
        self.append_column(col3)
        self._col.add_attribute(cr, 'text', 5)
        col2.add_attribute(cr2, 'text', 1)
        col3.add_attribute(cr3, 'text', 2)
        col3.add_attribute(cr3, 'xalign', 3)
        col3.add_attribute(cr3, 'weight', 4)
    def getStore(self):
        return self._store
    def getSelected(self):
        (store, iter) = self.get_selection().get_selected()
        if iter:
            return iter
        return None

class ExpenseStore(gtk.ListStore, ):
    def __init__(self, id):
        gtk.ListStore.__init__(self, str, str, str, float, int, str, gobject.TYPE_UINT64, str)
        self._id = id
    def getId(self):
        return self._id
    def getUuid(self, iter):
        return self.get_value(iter, 0)
    def getAmountInteger(self, iter):
        return self.get_value(iter, 6)
