
import gtk, hildon, gobject, pango
import time
from lib.mvc import view
from lib.mvc.widgets import *
DETAIL_AREA_WIDTH = 327
TOP_PADDING = 16
MIDDLE_PADDING = 0
PAIR_PADDING = 10
MINIMAL_TAGS_HEIGHT = 66
MAXIMAL_TAGS_HEIGHT = 70
MAXIMAL_DESCRIPTION_HEIGHT = 100
PAIR_ITEM_WIDTH = (((DETAIL_AREA_WIDTH - 10) - PAIR_PADDING) / 2)
PAIR_HEIGHT = 35
BOTTOM_HEIGHT = 82
BUTTONS_WIDTH = 285
SMALL_BUTTON_HEIGHT = 48
SCROLLBAR_ESTIMATE = 10

class DetailView(view.View, ):
    names = ('amount', 'tags', 'date', 'description')
    strings = ('Price:', 'Tags:', 'Purchase date:', 'Description:')
    pairsArgs = ({'big': True, 'maxHeight': MINIMAL_TAGS_HEIGHT}, {'big': True, 'minHeight': MINIMAL_TAGS_HEIGHT, 'maxHeight': MAXIMAL_TAGS_HEIGHT}, {}, {'expand': True, 'fill': True, 'maxHeight': MAXIMAL_DESCRIPTION_HEIGHT})
    def _init_(self):
        self.setWidget(newPannableArea(size_request=((DETAIL_AREA_WIDTH - SCROLLBAR_ESTIMATE), -1)))
        self._eventBox = newEventBox()
        self.getWidget().add_with_viewport(self._eventBox)
        self.add(self._eventBox, 'root_eb')
        self._pairs = {}
        self._vbox = newVBox(spacing=MIDDLE_PADDING)
        self._eventBox.add(self._vbox)
        self._vbox.pack_start(newLabel(size_request=(-1, TOP_PADDING)), expand=False, fill=True)
        self._descEmpty = False
        for (name, label, args) in zip(self.names, self.strings, self.pairsArgs):
            self._pairs[name] = self._add_pair(name, label, '/', **args)
        self._buttons = self._get_buttons()
        self._vbox.pack_end(self._buttons, fill=False, expand=False)
        self.add(self._buttons.getEditButton(), 'button_edit')
        self.add(self._buttons.getDeleteButton(), 'button_delete')
    def expand(self):
        for (name, pair) in self._pairs.items():
            pair.expand()
    def set_values(self, dct):
        for (var, val) in dct.items():
            self.set_value(var, val, False)
        self.getWidget().show_all()
        if ('description' in dct):
            if (len(dct['description'].strip()) < 1):
                self._descEmpty = True
                self._pairs['description'].hide()
            else:
                self._descEmpty = False
    def set_value(self, var, value, reshow=True):
        if (var in self.names):
            self._pairs[var].set_value(value, ignoreTruncate=(True if (len(value) < 0) else False))
            if reshow:
                self.getWidget().show_all()
                if self._descEmpty:
                    self._pairs['description'].hide()
    def _add_pair(self, name, label, value, big=False, expand=False, fill=False, minHeight=None, maxHeight=None, **args):
        pair = DetailBoxPair(name, label, value, big, minHeight, maxHeight, **args)
        self._vbox.pack_start(pair, padding=0, expand=expand, fill=fill)
        return pair
    def _get_buttons(self):
        return DetailBoxButtonsView()
    def getButtons(self):
        return self._buttons

class DetailBoxPair(gtk.HBox, ):
    def __init__(self, name, label, value, big=False, minHeight=None, maxHeight=None, **args):
        size_request = (-1, PAIR_HEIGHT)
        if minHeight:
            size_request = (-1, PAIR_HEIGHT)
        if maxHeight:
            size_request = (-1, -1)
        gtk.HBox.__init__(self, False, 0)
        self.set_name(('detail_pair_%s' % ('big' if big else 'small')))
        self.set_size_request(*size_request)
        self._name = name
        self._minHeight = minHeight
        self._maxHeight = maxHeight
        self._truncated = False
        self._original = None
        self._nameLabel = self._get_name_label(label)
        self.pack_start(self._nameLabel, fill=True, expand=True)
        self._valueLabel = self._get_value_label(value)
        self.pack_start(self._valueLabel, fill=True, padding=PAIR_PADDING)
    def _truncate(self, value):
        return (' '.join(value.split(' ')[:-1]).rstrip(',') + '...')
    def _get_name_label(self, label):
        return newLabel(text=label, alignment=(1.0, 0.0), padding=(0, 2), size_request=((PAIR_ITEM_WIDTH - PAIR_PADDING), (self._minHeight if self._minHeight else -1)))
    def _get_value_label(self, value):
        label = newLabel(text=value, alignment=(0.0, 0.0), padding=(0, 2), size_request=((PAIR_ITEM_WIDTH - PAIR_PADDING), -1), line_wrap=True, line_wrap_mode=pango.WRAP_WORD_CHAR)
        layout = label.get_layout()
        layout.set_width(((PAIR_ITEM_WIDTH - PAIR_PADDING) - 1))
        return label
    def expand(self):
        if self._truncated:
            self.set_value(self._original, True)
            self._truncated = False
    def set_value(self, value, ignoreTruncate=False, recursing=False):
        if self._minHeight:
            self._valueLabel.set_size_request((PAIR_ITEM_WIDTH - 10), -1)
        self._valueLabel.set_text(str(value))
        if (not(ignoreTruncate) and self._maxHeight and (self._valueLabel.size_request()[1] > self._maxHeight)):
            if not(self._truncated):
                self._truncated = True
                self._original = value
            self.set_value(self._truncate(value), recursing=True)
        else:
            if not(recursing):
                self._truncated = False
        if (self._minHeight and (self._valueLabel.size_request()[1] < self._minHeight)):
            self._valueLabel.set_size_request((PAIR_ITEM_WIDTH - 10), self._minHeight)
        sr = self._valueLabel.get_size_request()
        self._valueLabel.set_size_request(*sr)
    def getValueLabel(self):
        return self._valueLabel
    def getNameLabel(self):
        return self._nameLabel

class DetailBoxButtons(gtk.EventBox, ):
    PADDING_HOR = 2
    PADDING_VER = ((BOTTOM_HEIGHT - SMALL_BUTTON_HEIGHT) / 2)
    PADDING_BOTTOM = 5
    def __init__(self, **args):
        gtk.EventBox.__init__(self)
        self.set_name('detail_bottom')
        self.set_size_request(-1, BOTTOM_HEIGHT)
        self._vbox = newVBox(False, 0)
        self._hbox = newHBox(False, self._get_hbox_padding())
        self._vbox.pack_start(newLabel(size_request=(-1, self.PADDING_VER)))
        self._vbox.pack_start(self._hbox, fill=False, expand=False)
        self._vbox.pack_start(newLabel(size_request=(-1, (self.PADDING_VER + self.PADDING_BOTTOM))))
        self._hbox.pack_start(newLabel(size_request=(self.PADDING_HOR, -1)), expand=False)
        self.add(self._vbox)
    def _get_hbox_padding(self):
        return 0

class DetailBoxButtonsView(DetailBoxButtons, ):
    def __init__(self, **args):
        DetailBoxButtons.__init__(self)
        w = ((BUTTONS_WIDTH - self._get_hbox_padding()) / 2)
        self._editButton = newButton(label='Edit', size_request=(w, SMALL_BUTTON_HEIGHT))
        self._deleteButton = newButton(label='Delete', size_request=(w, SMALL_BUTTON_HEIGHT))
        self._hbox.pack_start(self._editButton, fill=False)
        self._hbox.pack_start(self._deleteButton, fill=False)
        self._hbox.pack_start(newLabel(), expand=True)
    def getEditButton(self):
        return self._editButton
    def getDeleteButton(self):
        return self._deleteButton
