
import logging
import gobject, gtk, pango
import format
from lib.mvc.ctrl import Ctrl
from lib.mvc.widgets import truncateText
from lib.util import task, locality
from app.view.expense import ExpenseSection

class ExpenseCtrl(Ctrl, ):
    _type = ExpenseSection.TYPE_TIMELINE
    _detail = 'tldetail'
    FILL_DELAY = 100
    FILL_LIMIT = 5
    def _init_(self):
        self._pressed = False
        self._changed = None
        self._selected = None
        self._ids = []
        self._uuids = {}
        self._generator = None
        self._task = task.Task(self.fill_data, None, self.fill_data_end)
        self._filled = False
        self._da = gtk.DrawingArea()
        self.getWidget().connect('button-press-event', self.on_expense_root_button_press_event)
        self.getWidget().connect('button-release-event', self.on_expense_root_button_release_event)
        self.getWidget().connect('vertical-movement', self.on_expense_root_vertical_movement)
    def getDetail(self):
        return self.getView(self._detail)
    def getSection(self, id):
        return self.getView().getSection(id)
    def newSection(self, id, pos=None):
        title = self._sectionIdToTitle(id)
        self.getView().appendSection(self._type, id, truncateText(title, 440, 70, 'Nokia Sans Bold 15', widget=self._da), pos)
        self.getSection(id).getTreeView().connect('cursor-changed', self.on_cursor_changed, id)
        self._ids.append(id)
        self._ids.sort(locality.getStrCol())
        if (self._type == ExpenseSection.TYPE_TIMELINE):
            self._ids.reverse()
        self.getSection(id).setSortOrder((True if (self._type == ExpenseSection.TYPE_TIMELINE) else False))
        self.getSection(id).show_all()
    def selectFirst(self, sid=None, force=False, scroll=True):
        if (force and (self._selected != None)):
            self.getSection(self._selected.sid).unselectAll()
            self._selected = None
        if ((self._selected == None) and (len(self._ids) > 0)):
            section = None
            if sid:
                section = self.getSection(sid)
            if not(section):
                sid = self._ids[0]
                section = self.getSection(sid)
            (iter, uuid) = section.selectFirst()
            self._item_selected(ExpenseSelected(sid, uuid, iter), scroll=scroll)
    def selectLast(self, sid, scroll=True):
        if (len(self._ids) > 0):
            section = self.getSection(sid)
            if section:
                store = section.getStore()
                cnt = store.iter_n_children(None)
                if (cnt > 0):
                    iter = store.get_iter(((cnt - 1),))
                    if iter:
                        self.select(store.getUuid(iter), sid, scroll=scroll)
    def select(self, uuid, sid=None, scroll=True):
        if (uuid in self._uuids):
            sections = self._uuids[uuid]
            if ((sid != None) and (sid in sections)):
                (sectionId, iter) = (sid, sections[sid])
            else:
                order = sections.keys()
                order.sort(locality.getStrCol())
                sectionId = order[0]
                iter = sections[sectionId]
            if self._selected:
                for id in self._ids:
                    if (id != sectionId):
                        self.getSection(id).unselectAll()
                self.getSection(sectionId).selectIter(iter)
            self._item_selected(ExpenseSelected(sectionId, uuid, iter), True, scroll)
    def registerRow(self, index, iter, uuid):
        if (uuid not in self._uuids):
            self._uuids[uuid] = {}
        self._uuids[uuid][index] = iter
    def addRow(self, sections, uuid, text, amount, amountInteger, date, insert=False):
        if (uuid not in self._uuids):
            self._uuids[uuid] = {}
        for id in sections:
            if (id not in self._ids):
                pos = (self._getSectionPos(id) if insert else None)
                self.newSection(id, pos)
            section = self.getSection(id)
            iter = section.addRow(uuid, text, amount, amountInteger, date, (0 if insert else None))
            self._uuids[uuid][id] = iter
            if (insert and (self._type == ExpenseSection.TYPE_TAGS)):
                section.updateSummer(self.getApp().getAccount().getNumberFormat())
        if (insert and (self._type == ExpenseSection.TYPE_TIMELINE)):
            self.addToSum(amountInteger)
            self.updateSummer()
    def getSelectedByUuid(self, uuid):
        sels = []
        if (uuid in self._uuids):
            for (id, iter) in self._uuids[uuid].items():
                sels.append(ExpenseSelected(id, uuid, iter))
        return sels
    def removeRow(self, uuid):
        logging.debug(('Removing rows of expense %s' % uuid))
        am = 0
        down = False
        for selected in self.getSelectedByUuid(uuid):
            section = self.getSection(selected.sid)
            down = self.downRow(False)
            if not(down):
                down = self.upRow(False)
            am = section.removeRow(selected.iter)
            if not(section.getStore().get_iter_first()):
                self._ids.remove(selected.sid)
                self.getView().removeSection(selected.sid)
            else:
                if (self._type == ExpenseSection.TYPE_TAGS):
                    section.addToSum(-(am))
                    section.updateSummer(self.getApp().getAccount().getNumberFormat())
        if (self._type == ExpenseSection.TYPE_TIMELINE):
            self.addToSum(-(am))
            self.updateSummer()
        if (uuid in self._uuids):
            del self._uuids[uuid]
        if (len(self._uuids) < 1):
            self.getCtrl('area').fill()
            return True
        else:
            if not(down):
                self._selected = None
                self.selectFirst()
            else:
                self.scrollToSelected()
        return False
    def downRow(self, scroll=True):
        if (self.isFilled() and (len(self._uuids) > 0) and self._selected):
            store = self.getSection(self._selected.sid).getStore()
            next = store.iter_next(self._selected.iter)
            if next:
                uuid = store.getUuid(next)
                self.select(uuid, self._selected.sid, scroll=scroll)
                return True
            else:
                nextSid = self._getNextSection(self._selected.sid)
                if nextSid:
                    self.selectFirst(nextSid, force=True, scroll=scroll)
                    return True
        return False
    def upRow(self, scroll=True):
        if (self.isFilled() and (len(self._uuids) > 0) and self._selected):
            store = self.getSection(self._selected.sid).getStore()
            path = store.get_path(self._selected.iter)
            p = (path[0] - 1)
            if (p > -1):
                try:
                    prev = store.get_iter((p,))
                    uuid = store.getUuid(prev)
                    self.select(uuid, self._selected.sid, scroll=scroll)
                    return True
                except:
                    pass
            prevSid = self._getPrevSection(self._selected.sid)
            if prevSid:
                self.selectLast(prevSid, scroll=scroll)
                return True
        return False
    def scrollTo(self, section, iter):
        tree = section.getTreeView()
        store = section.getStore()
        rect = tree.get_cell_area(store.get_path(iter), tree.get_column(0))
        self.getWidget().scroll_to(0, ((rect.y + tree.allocation.y) + 20))
    def scrollToSelected(self):
        if self._selected:
            self.scrollTo(self.getSection(self._selected.sid), self._selected.iter)
    def _getNextSection(self, id):
        i = self._ids.index(id)
        try:
            return self._ids[(i + 1)]
        except IndexError:
            return None
    def _getPrevSection(self, id):
        i = self._ids.index(id)
        try:
            return (self._ids[(i - 1)] if (i > 0) else None)
        except IndexError:
            return None
    def clear(self):
        self._generator = None
        self._filled = False
        self._changed = None
        self._selected = None
        self._ids = []
        self._uuids = {}
        self.getDetail().getCtrl().clear()
        self.getDetail().getWidget().hide()
        self.getView().clear()
    def afterFill(self):
        return self._afterFill()
    def isFilled(self):
        return (self._filled != False)
    def fill(self):
        self.getApp().showLoading()
        self._generator = None
        self._filled = True
        return self._doFill()
    def fill_on(self):
        logging.info('Filling on')
        if self._generator:
            try:
                data = self._generator.next()
                self.fill_portion(data)
            except StopIteration:
                self._generator = None
                self.getApp().hideLoading()
    def fill_portion(self, data):
        self._task.start(data, noloop=True)
    def fill_data(self, data):
        for row in data:
            gobject.idle_add(self._doFillRow, row)
    def fill_data_end(self):
        self._doFillEnd()
        gobject.timeout_add(self.FILL_DELAY, self.fill_on)
    def _afterFill(self):
        pass
    def _sectionIdToTitle(self, id):
        pass
    def _getSectionPos(self, id):
        pass
    def _doFill(self):
        pass
    def _doFillRow(self, row):
        pass
    def _doFillEnd(self):
        pass
    def on_show(self, widget, data=None):
        pass
    def _item_selected(self, selected, force=False, scroll=True):
        if self._selected:
            if (self._selected.sid != selected.sid):
                self.getSection(self._selected.sid).unselectAll()
        self._selected = selected
        self.on_item_selected(selected, force)
    def on_item_selected(self, selected, force=False, scroll=True):
        self.getDetail().getCtrl().fillExpense(selected.uuid, force)
        if scroll:
            self.scrollTo(self.getSection(selected.sid), selected.iter)
    def on_cursor_changed(self, treeview, id):
        (store, iter) = (treeview.getStore(), treeview.getSelected())
        self._changed = ExpenseSelected(id, store.getUuid(iter), iter)
    def on_expense_root_button_press_event(self, widget, data=None):
        self._pressed = True
    def on_expense_root_button_release_event(self, widget, data=None):
        if (self._pressed and self._changed):
            self._item_selected(self._changed)
            self._changed = None
        else:
            if self._changed:
                self.getSection(self._changed.sid).unselectAll()
                if (self._selected and (self._changed.sid == self._selected.sid)):
                    self.getSection(self._selected.sid).selectIter(self._selected.iter)
                self._changed = None
        self._pressed = False
    def on_expense_root_vertical_movement(self, widget, direction, x, y, data=None):
        self._pressed = False

class ExpenseSelected(object, ):
    def __init__(self, sid, uuid, iter):
        self.sid = sid
        self.iter = iter
        self.uuid = uuid
    def __str__(self):
        return ('%s %s %s' % (self.sid, self.iter, self.uuid))
