
import logging
import datetime
import format
from lib.mvc.ctrl import Ctrl
from lib.util import task, tz
from app.view.area import *

class AreaCtrl(Ctrl, ):
    FILL_LIMIT = 5
    FILL_DELAY = 500
    def _init_(self):
        self._selected = 'timeline'
        self._emptyStart = EmptyStart()
        self._emptyTimespan = EmptyTimespan()
        self._isEmptyStart = False
        self._isEmptyTimespan = False
    def on_show(self, widget, data=None):
        self.fill()
    def on_add_button_clicked(self, widget, data=None):
        self.getApp().pushView('add')
        self.getCtrl('add').before_add()
    def switch(self, tab='timeline', show=True, force=False):
        if self._isEmptyStart:
            self.empty_start()
            self._selected = tab
            if show:
                self.getView().hideExpenseArea()
                self.getView().showDetailArea()
        else:
            if self._isEmptyTimespan:
                self.empty_timespan()
                self._selected = tab
                if show:
                    self.getView().hideExpenseArea()
                    self.getView().showDetailArea()
            else:
                if (tab in ('timeline', 'tags')):
                    if ((self._selected != tab) or force):
                        self.getView().fillExpenseArea(self.getView(tab).getWidget(), show)
                        self.getView().fillDetailArea(self.getView(('tldetail' if (tab == 'timeline') else 'tagsdetail')).getWidget(), show)
                        self._selected = tab
                        if not(self.getCtrl(tab).isFilled()):
                            self.getCtrl(tab).fill()
                        else:
                            self.getCtrl(tab).scrollToSelected()
                    if show:
                        self.getView().showExpenseArea()
    def reswitch(self, force=True):
        self.switch(self._selected, True, force)
    def getExpenseCtrl(self):
        return self.getCtrl(self._selected)
    def getDetailCtrl(self):
        return self.getCtrl(('tldetail' if (self._selected == 'timeline') else 'tagsdetail'))
    def scrollToSection(self, letter):
        if (self._selected == 'tags'):
            sid = self.getCtrl('tags').getSectionByLetter(letter)
            if (sid != None):
                try:
                    self.getCtrl('tags').selectFirst(sid, force=True)
                except:
                    pass
    def empty_start(self):
        self.getView().fillDetailArea(self._emptyStart, True, True)
        self.getView().hideExpenseArea()
    def empty_timespan(self):
        self._emptyTimespan.setTimespan(format.formatTimespan(self.getApp().getTimespan()))
        self.getView().fillDetailArea(self._emptyTimespan, True, True)
        self.getView().hideExpenseArea()
    def select(self, uuid):
        if (self.viewLoaded('timeline') and self.getCtrl('timeline').isFilled()):
            self.getCtrl('timeline').select(uuid)
        if (self.viewLoaded('tags') and self.getCtrl('tags').isFilled()):
            self.getCtrl('tags').select(uuid)
    def clear(self):
        if self.viewLoaded('timeline'):
            self.getCtrl('timeline').clear()
        if self.viewLoaded('tags'):
            self.getCtrl('tags').clear()
    def fill(self):
        self.clear()
        empty = self.getApp().getStore().isEmpty()
        count = 0
        if not(empty):
            count = self.getApp().getStore().countExpensesForDisplay(self.getApp().getTimespanRange())
        self._isEmptyStart = False
        self._isEmptyTimespan = False
        if empty:
            self.empty_start()
            self._isEmptyStart = True
        else:
            if (count < 1):
                self.empty_timespan()
                self._isEmptyTimespan = True
            else:
                self.getCtrl(self._selected).fill()
                self.switch(self._selected, True, True)
    def add_row(self, row, insert=False, view=None):
        if (insert and (self._isEmptyStart or self._isEmptyTimespan)):
            self.fill()
            return False
        dateFormatted = format.formatDateSmart(row[2], self.getApp().getAccount().getDateFormat())
        amountFormatted = format.formatAmountTruncate(row[1], self.getApp().getAccount().getNumberFormat(), 140)
        if (view in (None, 'timeline')):
            if (self.viewLoaded('timeline') and self.getCtrl('timeline').isFilled()):
                self.getCtrl('timeline').addRow([row[2].isoformat()], row[0], truncateText(', '.join(row[3])), amountFormatted, row[1], row[2].isoformat(), insert)
        if (view in (None, 'tags')):
            if (self.viewLoaded('tags') and self.getCtrl('tags').isFilled()):
                self.getCtrl('tags').addRow(row[3], row[0], dateFormatted, amountFormatted, row[1], row[2].isoformat(), insert)
        return True
    def remove_row(self, uuid, view=None):
        empty = False
        if (view in (None, 'timeline')):
            if (self.viewLoaded('timeline') and self.getCtrl('timeline').isFilled()):
                empty = self.getCtrl('timeline').removeRow(uuid)
        if (view in (None, 'tags')):
            if (self.viewLoaded('tags') and self.getCtrl('tags').isFilled()):
                empty = self.getCtrl('tags').removeRow(uuid)
        return empty
