#include "transport.h"
#include <QStandardItem>
#include <QDebug>

Transport::Transport(const QString &line, TransportType type) :
        mLine(line), mType(type), mDistance(0), mEmpty(true)
{
}

Transport::Transport() :
        mLine(QString()), mType(Bus), mDistance(0), mEmpty(true)
{

}

void Transport::setLine(const QString &line) {
    mLine = line;
    mEmpty = false;

}

void Transport::setType( TransportType type) {
    mType = type;
    mEmpty = false;
}

void Transport::addStop( Stop newStop)
{
    mStops.append(newStop);
    mEmpty = false;

}

QDateTime Transport::startTime() const
{

    if (mStops.isEmpty()) {
        return QDateTime();
    } else {
        return mStops.first().departureTime();
    }
}

QDateTime Transport::endTime() const
{
    if (mStops.isEmpty()) {
        return QDateTime();
    } else {
        return mStops.last().arrivalTime();
    }
}

QTime Transport::time() const
{
    return QTime(0, 0, startTime().secsTo(endTime()), 0);

}

Coordinates Transport::startCoordinates() const
{
    if (mStops.isEmpty()) {
        return makeCoordinates(0,0);
    } else {
        return mStops.first().coordinates();
    }
}

Coordinates Transport::endCoordinates() const
{
    if (mStops.isEmpty()) {
        return makeCoordinates(0,0);
    } else {
        return mStops.last().coordinates();
    }
}

float Transport::distance() const {

    return mDistance;

}

void Transport::setDistance(float distance)
{

    mEmpty = false;
    if (distance > 0)
        mDistance = distance;

}

void Transport::debug() const {

    qDebug() << "Transport" << mLine << mType;

//    Stop stop;
    foreach (const Stop &stop, mStops) {
        stop.debug();
    }

}

QStandardItem* Transport::model() const {

    QStandardItem *temp;
    Stop stop;

    if (mLine.isEmpty()) {
        temp = new QStandardItem("Walk");
    } else {
        temp = new QStandardItem(mLine);
    }

    foreach (stop, mStops) {
        temp->appendRow(stop.model());
    }

    return temp;
}

Stop::List Transport::stops() const {
    
    return mStops;
}
