#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QDateTime>
#include <QHash>

#include "routewindow.h"
#include "location.h"
#include <qmobilityglobal.h>

class QLineSelectEdit;
class QPushButton;
class QGridLayout;
class QTreeView;
class QStandardItemModel;
class QScrollArea;
class QModelIndex;
class displayInfoWidget;
class QMaemo5ValueButton;
class QMaemo5ListPickSelector;
class QMaemo5DatePickSelector;
class QMaemo5TimePickSelector;
class QSettings;
class Gps;
class InfoWindow;
class Ytv;


class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    explicit MainWindow(QWidget *parent = 0);
    
    ~MainWindow();


signals:

public slots:
    void searchRoute();

    void searchPlace();

    void lookupFrom();

    void lookupTo();

    void doneAction();

    void error(int);
    
    void about();
    
    void settings();

//    void selectDate();

private slots:

    void fromClicked();

    void fromSelected(const QString &);

    void toSelected(const QString &);

    void firstClicked();

    void secondClicked();

    void thirdClicked();
    
    void gpsClicked();
    
    void positionAvailable();
    
    void noPosition();
    
    void nowClicked();
    
    void resetStart();
    
    void resetEnd();
    
    void addFavorite();
    
    void fromFavorites();
    
    void fromFavSelected(const QString &);
    
    void toFavorites();
    
    void toFavSelected(const QString &);
    
private:

    QPushButton *favFromButton;
    QPushButton *favToButton;
    QLineSelectEdit *fromLineEdit;
    QLineSelectEdit *toLineEdit;
    QPushButton *fromGpsButton;
    QPushButton *toAddFavButton;
    QPushButton *nowButton;
    QMaemo5ValueButton *timeButton;
    QMaemo5ValueButton *dateButton;
    QPushButton *searchButton;
    QMaemo5ListPickSelector *pickerSuggestions;
    QSettings *mSettings;
    //    QTreeView *routesTree;

    QStandardItemModel *stopsModel;

    QGridLayout *grid;
    Ytv *mYtv;
//    QStandardItemModel *mModel;

//    displayInfoWidget *mInfo1;
//    displayInfoWidget *mInfo2;
//    displayInfoWidget *mInfo3;

    FinnishCoordinates coordinatesStart;
    FinnishCoordinates coordinatesEnd;
    QDateTime mDateTime;
    
    QMaemo5DatePickSelector *datePicker;
    
    QMaemo5TimePickSelector *timePicker;
    
//    QGeoPositionInfoSource *mGps;
    
    Gps *mGps;
    
    InfoWindow *mRouteWindow;
    
    Route::List mRoutes;

    int state;
    
    int mConnectionTime;

    void toggleBusy(int checkState);
    

     QHash<QString, FinnishCoordinates> mFavorites;

};

#endif // MAINWINDOW_H
