#include "gps.h"

#include <QGeoPositionInfo>
#include <QGeoPositionInfoSource>
#include <QTimer>
#include <QMessageBox>
#include <QDebug>

const int TIME_THRESHOLD = 4 * 60;
const int DISTANCE_THRESHOLD = 400;

Gps* Gps::data = NULL;

Gps::Gps() { 
}

Gps* Gps::instance() {
    if (!data) {
        data = new Gps();
        data->init();
        
    }
    return data;
}

void Gps::init()
{
#ifdef GPS
    mGps = QGeoPositionInfoSource::createDefaultSource(this);
    
    connect(mGps, SIGNAL(positionUpdated(QGeoPositionInfo)),
            this, SLOT(positionUpdated(QGeoPositionInfo)));
    connect(mGps, SIGNAL(updateTimeout()),
            this, SIGNAL(noPosition()));   
#endif
}


void Gps::getPosition() {
#ifdef GPS    
    mGps->requestUpdate();
#endif   
}

#ifdef GPS  
void Gps::positionUpdated(const QGeoPositionInfo & update) {

    qDebug() << "New pos:" << update;
    mLastPos = update.coordinate();
    emit positionAvailable();
    int i = 0;
    foreach (const QGeoCoordinate &pos, mAlarms) {
        if (pos.distanceTo(mLastPos) < DISTANCE_THRESHOLD) {
            Coordinates ret = makeCoordinates(mLastPos.longitude(), mLastPos.latitude());
            
            emit alarmTriggered( ret );
            mAlarms.removeAt( i ); //Delete elements from list
            mAlarmsTime.removeAt( i );
            QMessageBox msgBox;
             msgBox.setText(tr("Close to the stop, be ready."));
             msgBox.exec();
        }
        i++;
    }
    if (mAlarms.count() == 0)
        mGps->stopUpdates();

}
#endif

Coordinates Gps::currentPosition() {
#ifdef GPS     
    return makeCoordinates(mLastPos.longitude(), mLastPos.latitude());
  #endif  
}

void Gps::setAlarm(const Coordinates &place, const QDateTime &time) {
#ifdef GPS    
    if (closerTime.isNull())
        closerTime = time;
    else if (time < closerTime)
        closerTime = time;
    
    QGeoCoordinate geoPlace(place.second, place.first);
    qDebug() << "Set Alarm" << geoPlace << time;
    mAlarms.append( geoPlace );
    mAlarmsTime.append( time );
    
    if ( closerTime.secsTo(QDateTime::currentDateTime()) > TIME_THRESHOLD )
        mGps->setUpdateInterval(2 * 60 * 1000); //msecs
    else
        mGps->setUpdateInterval(20 * 1000); //msecs
    mGps->startUpdates();
#endif
}
