#ifndef YTV_H
#define YTV_H

#include <QObject>
#include "location.h"
#include "route.h"


class ytvPrivate;

class Ytv : public QObject
{

    Q_OBJECT

public:
    Ytv(QObject *parent = 0);

    ~Ytv();


    bool search(const QString &what);

    Location::List searchResults();

    bool reverseGeoCode(const float x, const float y);

    bool route(FinnishCoordinates start, FinnishCoordinates dest, const QDateTime &datetime);

    Route::List routeResults();

private:
    ytvPrivate* const p;


signals:
    void done();

    void error(int code);


};

#endif // YTV_H
