#include <QPushButton>
#include <QTreeWidget>
#include <QTreeWidgetItem>
#include <QGridLayout>
#include <QDebug>
#include <QLabel>
#include <QStandardItemModel>
#include <QScrollArea>
#include <QTimer>
#include <QSettings>

#include "mainwindow.h"
#include "ytv.h"
#include "fancydelegate.h"
#include "displayinfowidget.h"
#include "qlineselectedit.h"
#include "listfilterwidget.h"
#include "routewindow.h"
#include "gps.h"

#ifdef Q_WS_MAEMO_5
#include <QMaemo5TimePickSelector>
#include <QMaemo5DatePickSelector>
#include <QMaemo5ListPickSelector>
#include <QMaemo5ValueButton>
#include <QMaemo5InformationBox>

#endif

MainWindow::MainWindow(QWidget *parent) :
        QWidget(parent), mRouteWindow(0)
{
    
    setAttribute(Qt::WA_Maemo5StackedWindow);
    QIcon favIcon(":/icons/fav.png");
    favFromButton = new  QPushButton(favIcon, QString());
    favToButton = new QPushButton(favIcon, QString());
    fromLineEdit = new QLineSelectEdit(tr("From:"));
    toLineEdit = new QLineSelectEdit(tr("To:"));
    fromGpsButton = new QPushButton(tr("GPS"));
    fromGpsButton->setEnabled(false);
    nowButton = new QPushButton(tr("Now"));
    QIcon addFavIcon(":/icons/addfav.png");
    toAddFavButton = new QPushButton(addFavIcon, QString());
    mDateTime = QDateTime::currentDateTime();
    mSettings = new QSettings(QString::fromLatin1("QuieroLlegar"),
                              QString::fromLatin1("planner"), this);
    
    //    mRouteWindow.setParent(this);
    //    mRouteWindow.setAttribute(Qt::WA_Maemo5StackedWindow);
    
    mGps = new Gps(this);
    
    stopsModel = new QStandardItemModel(this);
    //    PickSelector();
    //    timeButton->setPickSelector(timePicker);
    
    timeButton = new QMaemo5ValueButton(tr("Time:"));
    timeButton->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    timePicker = new QMaemo5TimePickSelector();
    timeButton->setPickSelector(timePicker);
    timePicker->setCurrentTime(mDateTime.time());
    
    dateButton = new QMaemo5ValueButton(tr("Date:"));
    dateButton->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    datePicker = new QMaemo5DatePickSelector();
    dateButton->setPickSelector(datePicker);
    datePicker->setCurrentDate(mDateTime.date());
    
    searchButton = new QPushButton(tr("Search"));
    
    pickerSuggestions = new QMaemo5ListPickSelector(this);
    pickerSuggestions->setModel(stopsModel);
    
    mYtv = new Ytv(this);
    
    grid = new QGridLayout();
    
    mInfo1 = new displayInfoWidget();
    mInfo2 = new displayInfoWidget();
    mInfo3 = new displayInfoWidget();
    
//    mModel = new QStandardItemModel();
    
    state = 0;
    
    grid->addWidget(favFromButton, 0, 0, 1, 1);
    grid->addWidget(fromLineEdit, 0, 1, 1, 1);
    grid->addWidget(fromGpsButton, 0, 2, 1, 1);
    grid->addWidget(favToButton, 1, 0, 1, 1);
    grid->addWidget(toLineEdit, 1, 1, 1, 1);
    grid->addWidget(toAddFavButton, 1, 2, 1, 1);
    grid->addWidget(timeButton, 2, 0, 1, 1);
    grid->addWidget(dateButton, 2, 1, 1, 1);
    grid->addWidget(nowButton, 2, 2, 1, 1);
    grid->addWidget(searchButton, 3, 0, 1, 3);
    //    grid->addWidget(routesTree, 4, 0, 1, 3);
    
    grid->addWidget(mInfo1, 5, 0, 1, 3);
    grid->addWidget(mInfo2, 6, 0, 1, 3);
    grid->addWidget(mInfo3, 7, 0, 1, 3);
    
    /*
    QWidget* mainWidget = new QWidget(this);
    mainWidget->setLayout(grid);
    setWidget(mainWidget);
    */
    setLayout(grid);
    setWindowTitle(tr("Como Llego"));
    
    //Debug
    //    coordinatesStart.first = 2546445;
    //    coordinatesStart.second = 6675512;
    //    coordinatesEnd.first = 2549445;
    //    coordinatesEnd.second = 6675513;
    
    coordinatesStart.first = 0;
    coordinatesStart.second = 0;
    coordinatesEnd.first = 0;
    coordinatesEnd.second = 0;
    
    //connections
    
    connect(mYtv, SIGNAL(done()), this, SLOT(doneAction()));
    connect(mYtv, SIGNAL(error(int)), this, SLOT(error(int)));
    connect(fromLineEdit, SIGNAL(returnPressed()), this, SLOT(searchPlace()));
    connect(fromLineEdit, SIGNAL(editingFinished()), this, SLOT(resetStart()));
    connect(toLineEdit, SIGNAL(returnPressed()), this, SLOT(searchPlace()));
    connect(toLineEdit, SIGNAL(editingFinished()), this, SLOT(resetEnd()));
    
    //    connect(dateButton, SIGNAL(clicked()), this, SLOT(selectDate()));
    
    //    connect(timeButton, SIGNAL(clicked()), this, SLOT(selectTime()));
    
    connect(fromGpsButton, SIGNAL(clicked()), this, SLOT(gpsClicked()));
    
    connect(searchButton, SIGNAL(clicked()), this, SLOT(searchRoute()));
    
    connect(mGps, SIGNAL(positionAvailable()), this, SLOT(positionAvailable()));
    
    connect(mGps, SIGNAL(positionError()), this, SLOT(noPosition()));
    
    connect(nowButton, SIGNAL(clicked()), this, SLOT(nowClicked()));
    
    connect(toAddFavButton, SIGNAL(clicked()), this, SLOT(addFavorite()));
    
    connect(favFromButton, SIGNAL(clicked()), this, SLOT(fromFavorites()));
    
    connect(favToButton, SIGNAL(clicked()), this, SLOT(toFavorites()));
    
    connect(mInfo1, SIGNAL(clicked()), this, SLOT(firstClicked()));
    connect(mInfo2, SIGNAL(clicked()), this, SLOT(secondClicked()));
    connect(mInfo3, SIGNAL(clicked()), this, SLOT(thirdClicked()));
    
    
    //Loading settings
    int size = mSettings->beginReadArray("favorites");
    for (int i = 0; i < size; ++i) {
        mSettings->setArrayIndex(i);
        QString name = mSettings->value("name").toString();
        float x  = mSettings->value("x").toFloat();
        float y  = mSettings->value("y").toFloat();
//        qDebug() << "FAV" << name << x << y;
        mFavorites[name] = makeFinnishCoordinates(x,y);
    }
    mSettings->endArray();
    
}

MainWindow::~MainWindow() {
    
    if (mFavorites.count() > 0 ) {
        
        mSettings->beginWriteArray("favorites");
        QHashIterator<QString, FinnishCoordinates> i(mFavorites);
        int x=0;
        while (i.hasNext()) {
            i.next();
            
            mSettings->setArrayIndex(x++);
            mSettings->setValue("name", i.key());
            mSettings->setValue("x", i.value().first);
            mSettings->setValue("y", i.value().second);
            
        }
        mSettings->endArray();
    }
}
    
    void MainWindow::lookupFrom() {
        
        
    }
    
    void MainWindow::lookupTo() {
        
        
    }
    
    void MainWindow::searchRoute() {
        
        if (fromLineEdit->text() == tr("From") || toLineEdit->text() == tr("To:")) {
            QMaemo5InformationBox::information(this, tr("Where do you want to go to?"));
            return;
        }
        
        if (coordinatesStart.first == 0 ) {
            if (toLineEdit->text() == tr("To:")) {
                QMaemo5InformationBox::information(this, tr("Where do you want to go to?"));
                return;
            }
            toggleBusy(Qt::Checked);
            state = 4;
            mYtv->search(fromLineEdit->text());
            return;
        }
        
        if (coordinatesEnd.first == 0 ) {
            if (fromLineEdit->text() == tr("From:")) {
                QMaemo5InformationBox::information(this, tr("Where do you want to go to?"));
                return;
            }
            toggleBusy(Qt::Checked);
            state = 5;
            mYtv->search(toLineEdit->text());
            return;
        }
        
        QDateTime timeSearch;
        timeSearch.setDate(datePicker->currentDate());
        timeSearch.setTime(timePicker->currentTime());
        if ( mYtv->route(coordinatesStart, coordinatesEnd, timeSearch) ) {
            mInfo1->clear();
            mInfo2->clear();
            mInfo3->clear();
            state = 3;
            toggleBusy(Qt::Checked);
            
        }  else {
            QMaemo5InformationBox::information(this, tr("Busy with network request. Please wait."));
        }
        
    }
    
    void MainWindow::searchPlace() {
        
        if (sender() == fromLineEdit && fromLineEdit->text() != tr("From:") ) {
            if ( mYtv->search(fromLineEdit->text()) ) {
                state = 1;
                coordinatesStart = makeFinnishCoordinates(0,0);
                toggleBusy(Qt::Checked);
            } else {
                QMaemo5InformationBox::information(this, tr("Busy with network request. Please wait."));
            }
            
        } else if ( toLineEdit->text() != tr("To:") ) {
            if ( mYtv->search(toLineEdit->text()) ) {
                state = 2;
                coordinatesEnd = makeFinnishCoordinates(0,0);
                toggleBusy(Qt::Checked);
            } else  {
                QMaemo5InformationBox::information(this, tr("Busy with network request. Please wait."));
            }
        }
        //    pickerSuggestions->setCurrentIndex(0);
    }
    
    void MainWindow::doneAction() {
        
        Location loc;
        Location::List list;
        
        Route route;
        Route::List routes;
        QString temp;
        QStringList tempList;
        QList<QTreeWidgetItem *> items;
        QWidget *w;
        
        //    qDebug() << "done" << state;
        
        toggleBusy(Qt::Unchecked);
        
        switch (state) {
            
        case 1: //From search
            list = mYtv->searchResults();
            stopsModel->clear();
            
            if (list.count() > 0 ) {
                foreach(const Location &loca, list) {
                    stopsModel->appendRow(loca.model());
                }
                
                w = pickerSuggestions->widget(this);
                if (w) {
                    pickerSuggestions->disconnect();
                    connect(pickerSuggestions, SIGNAL(selected(QString)),
                            this, SLOT(fromSelected(QString)));
                    w->show();
                }
            } else {
                QMaemo5InformationBox::information(this, tr("Nothing found, try again"));
                
            }
            
            
            break;
            
    case 2:     //to search
        list = mYtv->searchResults();
        
        if (list.count() > 0 ) {
            stopsModel->clear();
            
            foreach(const Location &loca, list) {
                stopsModel->appendRow(loca.model());
            }
            w = pickerSuggestions->widget(this);
            if (w) {
                pickerSuggestions->disconnect();
                connect(pickerSuggestions, SIGNAL(selected(QString)),
                        this, SLOT(toSelected(QString)));
                w->show();
            }
        } else {
            QMaemo5InformationBox::information(this, tr("Nothing found, try again"));
            
        }
        
        break;
        
    case 3:     //route search
        
        routes = mYtv->routeResults();
        
//        mModel->clear();
        //
        //        foreach (route, routes) {
        //            temp = QString::number(route.numberTransports()) + QString::fromLatin1(" ") +  route.time().toString();
        //            tempList.append(temp);
        //            items.append(new QTreeWidgetItem(tempList));
        //            tempList.clear();
        //            //            routesTree->insertTopLevelItems(0, items);
        //            items.clear();
        //            mModel->appendRow(route.model());
        //        }
        
        //Hardcoded to three routes
        
        if (routes.count() >=1 ) {
            mInfo1->setRoute(routes.first());
        }
        
        if ( routes.count() >= 2) {
            mInfo2->setRoute(routes[1]);
        }
        
        if ( routes.count() >= 3) {
            mInfo3->setRoute(routes[2]);
        }
        
        qDebug() << tempList;
        qDebug() << routes.count();
        
        //        foreach(route, routes) {
        //            route.debug();
        //        }
        break;
        
    case 4: //From search chained (with the enter)
        list = mYtv->searchResults();
        
        if (list.count() > 0 ) {
            const Location place = list.first();
            fromLineEdit->setText( place.toString() );
            coordinatesStart = place.finnishCoordinates();
            QTimer::singleShot(0, this, SLOT(searchRoute()) );
            
        } else {
            QMaemo5InformationBox::information(this, tr("Nothing found, try again"));
            
        }
        break;
    case 5: //to search chained (with the enter)
        list = mYtv->searchResults();
        
        if (list.count() > 0 ) {
            const Location place = list.first();
            toLineEdit->setText( place.toString() );
            coordinatesEnd = place.finnishCoordinates();
            QTimer::singleShot(0, this, SLOT(searchRoute()) );
            
        } else {
            QMaemo5InformationBox::information(this, tr("Nothing found, try again"));
            
        }
        break;
        
    default:
        qDebug() << "Unknown state!!" <<state ;
    }
        
        state = 0;
    }
    
    void MainWindow::error(int code) {
        
        Q_UNUSED(code);
        
        toggleBusy(Qt::Unchecked);
        QMaemo5InformationBox::information(this, tr("Network error"));
        
    }
    
    //void MainWindow::selectDate() {
    //    
    ////    QMaemo5TimePickSelector picker;
    //    
    //    mDateTime.setDate(date.currenDate());
    //    
    //}
    //
    //void MainWindow::selectTime() {
    //    
    ////    QMaemo5TimePickSelector picker;
    //    
    //    mDateTime.setTime(timePicker->currentTime());
    //    
    //}
    
    
    void MainWindow::fromClicked() {
        
        stopsModel->clear();
    }
    
    void MainWindow::fromSelected(const QString &place) {
        
        fromLineEdit->setText(place);
        fromLineEdit->clearFocus();
        int i = pickerSuggestions->currentIndex();
        
        coordinatesStart = mYtv->searchResults().at(i).finnishCoordinates();
        
    }
    
    void MainWindow::toSelected(const QString &place) {
        
        toLineEdit->setText(place);
        toLineEdit->clearFocus();
        int i = pickerSuggestions->currentIndex();
        
        coordinatesEnd = mYtv->searchResults().at(i).finnishCoordinates();
        
    }
    
    void MainWindow::firstClicked() {
        //
        //    if (mRouteWindow)
        //        mRouteWindow->deleteLater();
        
        qDebug() << "CHILDREN" << children().count();
        
        mRouteWindow = new RouteWindow( (mYtv->routeResults().takeAt(0)) , this);
        
        //    connect(searchButton, SIGNAL(clicked()), mRouteWindow, SLOT(close()));
        mRouteWindow->show();
        
        //    mRouteWindow.setRoute(mYtv->routeResults().takeAt(0));
        //    mRouteWindow.clearRoute();
        //    mRouteWindow.show();
        
    }
    
    void MainWindow::secondClicked() {
        
        RouteWindow *window = new RouteWindow( (mYtv->routeResults().takeAt(1)), this );
        window->show();
    }
    
    void MainWindow::thirdClicked() {
        
        RouteWindow *window = new RouteWindow( (mYtv->routeResults().takeAt(2)), this );
        window->show();
    }
    
    void MainWindow::gpsClicked() {
        
        qDebug() << "gps";
        
        //    if (!mGps) {
        //        mGps = QGeoPositionInfoSource::createDefaultSource(this);
        //    }
        //    if (mGps) {
        //        connect(mGps, SIGNAL(positionUpdated(QGeoPositionInfo)),
        //                this, SLOT(positionUpdated(QGeoPositionInfo)));
        //        connect(mGps, SIGNAL(updateTimeout()),
        //                this, SLOT(noPosition()));   
        //        
        //        mGps->startUpdates();
        ////        mGps->requestUpdate(3000); //Doesnt work ¿?
        //        
        //        QLabel *label = new QLabel(tr("Getting Location"));
        //        label->setAlignment(Qt::AlignCenter);
        //        label->setTextInteractionFlags(Qt::NoTextInteraction);
        //        
        //        QMaemo5InformationBox *dialog = new QMaemo5InformationBox();
        //        dialog->setWidget(label);
        //        dialog->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
        //        dialog->setTimeout(3000);
        //        dialog->show();
        //        dialog->setAttribute(Qt::WA_DeleteOnClose);
        //    }
    }
    
    void MainWindow::positionAvailable() {
        
        
        
    }
    
    void MainWindow::noPosition() {
        
        QMaemo5InformationBox::information(this, tr("Imposible to get current location"));
    }
    
    void MainWindow::toggleBusy(int checkState)
    {
        setAttribute(Qt::WA_Maemo5ShowProgressIndicator, checkState == Qt::Checked);
    }
    
    void MainWindow::nowClicked() {
        
        mDateTime = QDateTime::currentDateTime();
        timePicker->setCurrentTime(mDateTime.time());
        datePicker->setCurrentDate(mDateTime.date());
        
        
    }
    
    void MainWindow::resetStart() {
        
        coordinatesStart.first = 0;
        coordinatesStart.second = 0;
        
    }
    
    void MainWindow::resetEnd() {
        
        coordinatesEnd.first = 0;
        coordinatesEnd.second = 0;
        
    }
    
    void MainWindow::addFavorite() {
        
        if (coordinatesEnd.first != 0) {
            mFavorites[toLineEdit->text()] = coordinatesEnd;
        } else {
            QMaemo5InformationBox::information(this, tr("Nothing to add!"));
        }
    }
    
    void MainWindow::fromFavorites() {
        
        stopsModel->clear();
        
        if (mFavorites.count() > 0 ) {
            QHashIterator<QString, FinnishCoordinates> i(mFavorites);
            while (i.hasNext()) {
                i.next();
                stopsModel->appendRow(new QStandardItem(i.key()));
//                qDebug() << "FAVDIS" << i.key();
            }
            
            QWidget *w = pickerSuggestions->widget(this);
            if (w) {
                pickerSuggestions->disconnect();
                connect(pickerSuggestions, SIGNAL(selected(QString)),
                        this, SLOT(fromFavSelected(QString)));
                w->show();
            }
        } else {
            QMaemo5InformationBox::information(this, tr("Create some first!"));
        }
    }
    
    void MainWindow::fromFavSelected(const QString &stop) {
        
        fromLineEdit->setText(stop);
        coordinatesStart = mFavorites.value(stop);
    }
    
    void MainWindow::toFavorites() {
        
        stopsModel->clear();      //Not very optimal ;)
        
        if (mFavorites.count() > 0 ) {
            QHashIterator<QString, FinnishCoordinates> i(mFavorites);
            while (i.hasNext()) {
                i.next();
                stopsModel->appendRow(new QStandardItem(i.key()));
            }
            
            QWidget *w = pickerSuggestions->widget(this);
            if (w) {
                pickerSuggestions->disconnect();
                connect(pickerSuggestions, SIGNAL(selected(QString)),
                        this, SLOT(toFavSelected(QString)));
                w->show();
            }
        } else {
            QMaemo5InformationBox::information(this, tr("Create some first!"));
        }
        
    }
    
    void MainWindow::toFavSelected(const QString &stop) {
        
        toLineEdit->setText(stop);
        coordinatesEnd = mFavorites.value(stop);
    }
    
