/***************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (directui@nokia.com)
**
** This file is part of libmeegotouch.
**
** If you have questions regarding the use of this file, please contact
** Nokia at directui@nokia.com.
**
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Lesser General Public
** License version 2.1 as published by the Free Software Foundation
** and appearing in the file LICENSE.LGPL included in the packaging
** of this file.
**
****************************************************************************/

#ifndef MBUTTONICONVIEW_P_H
#define MBUTTONICONVIEW_P_H

#include "mbuttonview_p.h"

class QTimeLine;
class QPixmap;

class MButtonIconViewPrivate : public MButtonViewPrivate
{
    Q_DECLARE_PUBLIC(MButtonIconView)
public:
    MButtonIconViewPrivate();
    ~MButtonIconViewPrivate();

    void drawGlowIcon(QPainter *painter, const QRectF &iconRect) const;
    const QImage& glowIcon(const QPixmap* pm, int radius, const QColor &color);
    
    QTimeLine* timelineShrink;
    QTimeLine* timelineGlow;
    
    qint64 glowCacheKey;
    QImage glowImage;
    int glowRadius;
    QColor glowColor;
};

#endif
