#!/usr/bin/perl -w

use strict;
use warnings;

die "Run with 2 args: source_file dest_file\n" unless(@ARGV == 2);
my $symbols = $ARGV[1];
my $orig = $ARGV[0];
die "Original file $orig not found\n" unless(-e $orig);
my %layouts;

while(<*.layout>) {
	/^(.+)\.layout$/;
	$layouts{$1} = "$1.layout";
}

open(OUT, ">$symbols") or die "Can't create file $symbols\n";
open(IN, "<$orig") or die "Can't open for read $orig file\n";
my $mode = 0;
while(<IN>) {
	if(!$mode && /^xkb_symbols\s+\"([^\"]+)/ && $layouts{$1}) {
		open(CONF, "<$layouts{$1}") or die "Can't open for read $layouts{$1} file\n";
		chomp($_ = <CONF>);
		print OUT "xkb_symbols \"$1\" {\n  name[Group1] = \"$_\";\n\n";
		foreach my $s(split/\s+/, <CONF>) { print OUT "  include \"nokia_vndr/rx-51($s)\"\n"; }
		print OUT "\n  key.type[Group1] = \"EIGHT_LEVEL\";\n\n";
		while(<CONF>) {
		  chomp;
 			my @s = split/\s+/;
			print OUT "  key \<$s[0]\> { [ " . join(', ', @s[1..6,3,4]) . " ] };\n" if(@s);
		}
		print OUT "};\n\n";
		close(CONF);
		$mode = 1;
		$_ = "";
	}
	unless($mode) {
		print OUT;
	} else {
#		next unless($_);
		($_) = split/\#/;
		next if(!$_ || /^\s*$/);
		while(/\{/) { s/\{//; $mode++; }
		while(/\}/) { s/\}//; $mode--; }
	}
}

exit;

print <<EOF;
partial alphanumeric_keys
xkb_symbols "ru" {
  include "nokia_vndr/rx-51(english_base)"
  include "nokia_vndr/rx-51(arrows_2btns)"

  name[Group1] = "Russian phonetic";

  key.type[Group1] = "EIGHT_LEVEL_SEMIALPHABETIC";

EOF

my @s;

while (<>) {
  chomp;
  @s = split/\s+/;
  print "  key \<$s[0]\> { [ " . join(', ', @s[1..6,3,4]) . " ] };\n" if(@s);
}
print <<EOF;

};
EOF

