/*   VLC-REMOTE for MAEMO 5
*   Copyright (C) 2010 Schutz Sacha <istdasklar@gmail.com>, Dru Moore <usr@dru-id.co.uk>, Yann Nave <yannux@onbebop.net>
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License version 2,
*   or (at your option) any later version, as published by the Free
*   Software Foundation
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details
*
*   You should have received a copy of the GNU General Public
*   License along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
#ifndef FAVOURITESMAINWINDOW_H
#define FAVOURITESMAINWINDOW_H

#include <QMainWindow>
#include <QtNetwork>
#include <QtXml>
#include <QListWidgetItem>
#include "appsettings.h"

#ifndef LIST_ITEM_TYPE_OFFSET
#define LIST_ITEM_TYPE_OFFSET 1000
#endif

namespace Ui {
    class FavouritesMainWindow;
}

class FavouritesMainWindow : public QMainWindow {
    Q_OBJECT
public:
    explicit FavouritesMainWindow(QWidget *parent = 0);
    ~FavouritesMainWindow();

public slots:
    void init();
    void onListSelectionChanged();
    void onLineEditTextChanged(QString text);
    void onBrowse();
    void onEdit();
    void onDelete();
    void setHomeFolder();
    void onEditSave();

protected slots:

signals:
    void browseDirectory(QString path);
    void closeSignal();

protected:
    void changeEvent(QEvent *e);
    void updateList();
    void closeEvent(QCloseEvent * event);

private:
    Ui::FavouritesMainWindow *ui;
    int mCurrentItemIndex;
    QList<VlcDirectory>* mFavourites;
    VlcDirectory mCurrentFavourite;
};

#endif // FAVOURITESMAINWINDOW_H
