/*   VLC-REMOTE for MAEMO 5
*   Copyright (C) 2010 Schutz Sacha <istdasklar@gmail.com>, Dru Moore <usr@dru-id.co.uk>, Yann Nave <yannux@onbebop.net>
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License version 2,
*   or (at your option) any later version, as published by the Free
*   Software Foundation
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details
*
*   You should have received a copy of the GNU General Public
*   License along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
#include <QStringList>
#include "appsettings.h"

AppSettings::AppSettings() {
}

AppSettings::~AppSettings() {
    ;
}

QString AppSettings::getCurrentKey() {
    QSettings sets;
    return sets.value("config/currentKey", "").toString();
}
QString AppSettings::getCurrentIp() {
    QSettings sets;
    return sets.value("account/" + getCurrentKey(), "").toString();
}
VlcDirectory AppSettings::getHomeDirectory() {
    QSettings sets;
    VlcDirectory home;
    home.name = sets.value("config/accounts/" + getCurrentKey() + "/homeDirName", "Default").toString();
    home.path = sets.value("config/accounts/" + getCurrentKey() + "/homeDirPath", "~/").toString();
    return home;
}
bool AppSettings::setHomeDirectory(VlcDirectory dir) {
    QSettings sets;
    sets.setValue("config/accounts/" + getCurrentKey() + "/homeDirName", dir.name);
    sets.setValue("config/accounts/" + getCurrentKey() + "/homeDirPath", dir.path);
    return true;
}
QList<VlcDirectory>* AppSettings::getFavourites() {
    QSettings sets;
    QList<VlcDirectory> * favourites = new QList<VlcDirectory>();

    sets.beginGroup("config/accounts/" + getCurrentKey() + "/favourites");
    foreach ( QString key, sets.allKeys())
    {
        VlcDirectory dir;
        // key is name
        dir.name = key;
        // value is path
        dir.path = sets.value(key, "~/").toString();
        favourites->append(dir);
    }
    sets.endGroup();
    return favourites;
}
bool AppSettings::addFavourite(VlcDirectory dir) {
    QSettings sets;
    // should check for existing first otherwise it overwrites
    if (0 < sets.value("config/accounts/" + getCurrentKey() + "/favourites/" + dir.name, "").toString().length()) {
        dir.name = "_" + dir.name;
        return addFavourite(dir);
    }
    sets.setValue("config/accounts/" + getCurrentKey() + "/favourites/" + dir.name, dir.path);
    return true;
}
bool AppSettings::deleteFavourite(VlcDirectory dir) {
    QSettings sets;
    sets.remove("config/accounts/" + getCurrentKey() + "/favourites/" + dir.name);
    return true;
}
Orientation AppSettings::setOrientation(Orientation orientation) {
    QSettings sets;
    sets.setValue("config/orientation", (int)orientation);
    return orientation;
}
Orientation AppSettings::getOrientation() {
    QSettings sets;
    return (Orientation)(sets.value("config/orientation", AUTO_ROTATE).toInt());
}

