unit txqtfunc;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, qt4, LCLType, qtwidgets, x, xatom, xlib;

type
  // Note that aoAuto drains more battery as rotation daemon needs to be active..
  TAppOrientation = (aoHorizontal, aoVertical, aoAuto);

// My functions
procedure RotateApp(mform_handle : HWND; ao : TAppOrientation);
procedure UseFullscreen(mform_handle:HWND; fullscreen : boolean);
function UseZoomKeys(mform_handle: HWND; use : boolean):boolean;

implementation

procedure RotateApp(mform_handle : HWND; ao : TAppOrientation);
begin
  case ao of
    aoHorizontal: QWidget_setAttribute(TQtWidget(mform_handle).Widget,QtWA_Maemo5LandscapeOrientation , true);
    aoVertical  : QWidget_setAttribute(TQtWidget(mform_handle).Widget,QtWA_Maemo5PortraitOrientation , true);
    aoAuto      : QWidget_setAttribute(TQtWidget(mform_handle).Widget,QtWA_Maemo5AutoOrientation , true);
  end;
end;

procedure UseFullscreen(mform_handle:HWND; fullscreen : boolean);
begin
  if fullscreen then
    QWidget_showFullScreen(TQtWidget(mform_handle).Widget)
  else
    QWidget_showNormal(TQtWidget(mform_handle).Widget);
end;

function UseZoomKeys(mform_handle: HWND; use : boolean):boolean;
var
  at : TAtom;
  val : cardinal;
begin
  Result := True;
  if use then
    val := 1
  else
    val := 0;
  at := XInternAtom(QX11Info_Display, '_HILDON_ZOOM_KEY_ATOM', False);
  if at = 0 then
    begin
      Exit(false);
    end;
  XChangeProperty(QX11Info_Display, QWidget_winId(TQtWidget(mform_handle).Widget),at, XA_INTEGER, 32, PropModeReplace, @val ,1);
end;

end.

