unit txprocess;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Process, ExtCtrls, Dialogs, StdCtrls, SynEdit;

type
  TTxProcess = class (TObject)
    FProcess   : TProcess;
    FTimer     : TIdleTimer;
    FOutSL     : TStringList;
    FOutMemo   : TSynEdit;
    FCmdLine   : string;
    procedure TxOnTimer(Sender : TObject);
    procedure TxReadOutput;
  private
    procedure TxSetCmdLine(s : string);
  public
    constructor Create;
    destructor Destroy; override;
    procedure Execute;
  published
    property CmdLine : string read FCmdLine write TxSetCmdLine;
  end;

implementation

constructor TTxProcess.Create;
begin
  // Create the process..
  FProcess := TProcess.Create(nil);
  FProcess.Options := [poStdErrToOutput, poUsePipes];
  // Create the timer..
  FTimer := TIdleTimer.Create(nil);
  FTimer.Interval:= 50;
  FTimer.OnTimer:= @TxOnTimer;
  // Create the string list
  FOutSL := TStringList.Create;
end;

destructor TTxProcess.Destroy;
begin
  FProcess.Free;
  FTimer.Free;
  FOutSL.Free;
end;

procedure TTxProcess.TxSetCmdLine(s : string);
begin
  FCmdLine := s;
  FProcess.CommandLine := s;
end;

procedure TTxProcess.TxOnTimer(Sender : TObject);
begin
  TxReadOutput;
end;

procedure TTxProcess.TxReadOutput;
var
  NoMoreOutput: boolean;

  procedure DoStuffForProcess(Process: TProcess; OutputSL: TStringList);
  var
    Buffer: string;
    BytesAvailable: DWord;
    BytesRead:LongInt;
    wrote_something : boolean;
  begin
  //  if Process.Running then
    begin
      BytesAvailable := Process.Output.NumBytesAvailable;
      BytesRead := 0;
      wrote_something := False;
      while BytesAvailable>0 do
      begin
        SetLength(Buffer, BytesAvailable);
        BytesRead := Process.OutPut.Read(Buffer[1], BytesAvailable);
        OutputSL.Text := OutputSL.Text + copy(Buffer,1, BytesRead);
        BytesAvailable := Process.Output.NumBytesAvailable;
        NoMoreOutput := false;
        wrote_something := True;
      end;
      if Assigned(FOutMemo) and wrote_something then
        begin
          FOutMemo.Text := FOutSL.Text;
        end;
    end;
  end;
begin
  repeat
    NoMoreOutput := true;
    DoStuffForProcess(FProcess, FOutSL);
  until noMoreOutput;
end;

procedure TTxProcess.Execute;
begin
  if CmdLine = '' then
    begin
      ShowMessage('Command Line is empty, won''t execute..');
      Exit;
    end;
  FOutSL.Clear;
  FTimer.Enabled := True;
  FProcess.Execute;
end;

end.

