unit ftpserverlist;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  IniFiles, qtwidgets, qt4;

type

  { TftpServerListF }
  TxFtpServer = record
    id       : integer;
    Name     : string;
    Address  : string;
    Username : string;
    Password : string;
    Port     : string;
    SavePass : boolean;
    Passive  : boolean;
  end;
  TxFtpServerList = array of TxFtpServer;

TftpServerListF = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Edit5: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    ListBox1: TListBox;
    procedure Button3Click(Sender: TObject);
procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ListBox1SelectionChange(Sender: TObject; User: boolean);
  private
    { private declarations }
  public
    { public declarations }
    FTPServerList : TxFTPServerList;
    currentServer : TxFTPServer;
    lastListBoxIndex : integer;
    isDeleting, justSaved : boolean;
    procedure LoadServers;
    procedure SaveServers;
  end; 

var
  ftpServerListF: TftpServerListF;

implementation

uses MainUnit;

{$R *.lfm}

{ TftpServerListF }
procedure TftpServerListF.SaveServers;
var
  ini : TMemIniFile;
  s_count, i : integer;
begin
  if not isDeleting then
    begin
      // Save this server details to array first..
      FTPServerList[ListBox1.ItemIndex].Name := Edit1.Text;
      FTPServerList[ListBox1.ItemIndex].Address := Edit2.Text;
      FTPServerList[ListBox1.ItemIndex].Username := Edit3.Text;
      FTPServerList[ListBox1.ItemIndex].Password := Edit4.Text;
      FTPServerList[ListBox1.ItemIndex].Port := Edit5.Text;
      FTPServerList[ListBox1.ItemIndex].SavePass := CheckBox1.Checked;
      FTPServerList[ListBox1.ItemIndex].Passive := CheckBox2.Checked;
      isDeleting := False;
    end;

  ini := TMemIniFile.Create(MainUnit.CONFIG_FILE);
  ini.EraseSection('FTPServers');
  ini.WriteInteger('FTPServers','server_count',length(FTPServerList));
  for i := 0 to length(FTPServerList)-1 do
    begin
      ini.WriteString('FTPServers','SName'+inttostr(i),FTPServerList[i].Name);
      ini.WriteString('FTPServers','SAddress'+inttostr(i),FTPServerList[i].Address);
      ini.WriteString('FTPServers','SUser'+inttostr(i),FTPServerList[i].Username);
      if CheckBox1.Checked then
        ini.WriteString('FTPServers','SPass'+inttostr(i),FTPServerList[i].Password);
      ini.WriteString('FTPServers','SPort'+inttostr(i),FTPServerList[i].Port);
      ini.WriteBool('FTPServers','SSPass'+inttostr(i),FTPServerList[i].SavePass);
      ini.WriteBool('FTPServers','SPassive'+inttostr(i),FTPServerList[i].Passive);
    end;
  ini.UpdateFile;
  ini.Free;
  justSaved := True;
end;

procedure TftpServerListF.LoadServers;
var
  ini : TMemIniFile;
  s_count, i : integer;
begin
  SetLength(FTPServerList,0);
  FTPServerList := nil;
  ini := TMemIniFile.Create(MainUnit.CONFIG_FILE);
  s_count := ini.ReadInteger('FTPServers','server_count',0);
  if s_count < 1 then
    Exit;
  SetLength(FTPServerList, s_count);

  for i := 0 to s_count - 1 do
    begin
      FTPServerList[i].Name := ini.ReadString('FTPServers','SName'+inttostr(i),'');
      FTPServerList[i].Address := ini.ReadString('FTPServers','SAddress'+inttostr(i),'');
      FTPServerList[i].Username := ini.ReadString('FTPServers','SUser'+inttostr(i),'');
      FTPServerList[i].Password := ini.ReadString('FTPServers','SPass'+inttostr(i),'');
      FTPServerList[i].Port := ini.ReadString('FTPServers','SPort'+inttostr(i),'');
      FTPServerList[i].SavePass := ini.ReadBool('FTPServers','SSPass'+inttostr(i),False);
      FTPServerList[i].Passive := ini.ReadBool('FTPServers','SPassive'+inttostr(i),True);
    end;
  ini.Free;

  ListBox1.Clear;
  for i := 0 to s_count-1 do
    begin
      ListBox1.Items.Add(FTPServerList[i].Name);
    end;
  ListBox1.ItemIndex := 0;
end;

procedure TftpServerListF.FormShow(Sender: TObject);
var
  edt : TQtLineEdit;
begin

  edt := TQtLineEdit(Edit1.Handle);
  QWidget_setInputMethodHints(edt.Widget,QtImhNoAutoUppercase);
  edt.StyleSheet:= ' QLineEdit { border: 1px solid gray; ' +
                               ' border-radius: 0px; ' +
                               ' padding: 0 0px; ' +
                               ' background-color : white }';
  edt := TQtLineEdit(Edit2.Handle);
  QWidget_setInputMethodHints(edt.Widget,QtImhNoAutoUppercase);
  edt.StyleSheet:= ' QLineEdit { border: 1px solid gray; ' +
                               ' border-radius: 0px; ' +
                               ' padding: 0 0px; ' +
                               ' background-color : white }';
  edt := TQtLineEdit(Edit3.Handle);
  QWidget_setInputMethodHints(edt.Widget,QtImhNoAutoUppercase);
  edt.StyleSheet:= ' QLineEdit { border: 1px solid gray; ' +
                               ' border-radius: 0px; ' +
                               ' padding: 0 0px; ' +
                               ' background-color : white }';
  edt := TQtLineEdit(Edit4.Handle);
  QWidget_setInputMethodHints(edt.Widget,QtImhNoAutoUppercase);
  edt.StyleSheet:= ' QLineEdit { border: 1px solid gray; ' +
                               ' border-radius: 0px; ' +
                               ' padding: 0 0px; ' +
                               ' background-color : white }';
  edt := TQtLineEdit(Edit5.Handle);
  QWidget_setInputMethodHints(edt.Widget,QtImhNoAutoUppercase or QtImhPreferNumbers or QtImhDigitsOnly);
  edt.StyleSheet:= ' QLineEdit { border: 1px solid gray; ' +
                               ' border-radius: 0px; ' +
                               ' padding: 0 0px; ' +
                               ' background-color : white }';

  LoadServers;
end;

procedure TftpServerListF.Button5Click(Sender: TObject);
var
  index : integer;
begin
  index := ListBox1.Items.Add('Untitled 1');
  SetLength(FTPServerList,length(FTPServerList)+1);
  ListBox1.ItemIndex := index;
end;

procedure TftpServerListF.FormCreate(Sender: TObject);
begin
  isDeleting := False;
end;

procedure TftpServerListF.Button4Click(Sender: TObject);
var
  index : integer;
begin
  index := ListBox1.ItemIndex;
  if index < 0 then
    Exit;
  SaveServers;
  LoadServers;
  ListBox1.ItemIndex := index;
end;

procedure TftpServerListF.Button3Click(Sender: TObject);
var
  i, index : integer;
begin
  index := ListBox1.ItemIndex;
  if index < 0 then
    Exit;
  isDeleting := True;
  // Now delete from array...
  if Length(FTPServerList) > 1 then
    begin
      for i := index+1 to Length(FTPServerList)-1 do
        begin
          FTPServerList[i-1] := FTPServerList[i];
        end;
      SetLength(FTPServerList, Length(FTPServerList)-1);
    end
  else
    begin
      SetLength(FTPServerList, 0);
      FTPServerList := nil;
    end;
  //Save and reload..
  SaveServers;
  LoadServers;
  if Length(FTPServerList) > 0 then
    ListBox1.ItemIndex := 0;

  isDeleting := False;
end;

procedure TftpServerListF.ListBox1SelectionChange(Sender: TObject; User: boolean
  );
begin
  if User and not isDeleting and not justSaved then
    begin
      // Save this server details to array first..
      FTPServerList[LastListBoxIndex].Name := Edit1.Text;
      FTPServerList[LastListBoxIndex].Address := Edit2.Text;
      FTPServerList[LastListBoxIndex].Username := Edit3.Text;
      FTPServerList[LastListBoxIndex].Password := Edit4.Text;
      FTPServerList[LastListBoxIndex].Port := Edit5.Text;
      FTPServerList[LastListBoxIndex].SavePass := CheckBox1.Checked;
      FTPServerList[LastListBoxIndex].Passive := CheckBox2.Checked;
      LastListBoxIndex := -2;
    end
  else
    begin
      JustSaved := False;
      isDeleting := False;
    end;

  // Now update Edit fields..
  Edit1.Text := FTPServerList[ListBox1.ItemIndex].Name;
  Edit2.Text := FTPServerList[ListBox1.ItemIndex].Address;
  Edit3.Text := FTPServerList[ListBox1.ItemIndex].Username;
  Edit4.Text := FTPServerList[ListBox1.ItemIndex].Password;
  Edit5.Text := FTPServerList[ListBox1.ItemIndex].Port;
  CheckBox1.Checked := FTPServerList[ListBox1.ItemIndex].SavePass;
  CheckBox2.Checked := FTPServerList[ListBox1.ItemIndex].Passive;
  currentServer := FTPServerList[ListBox1.ItemIndex];
  lastListBoxIndex := ListBox1.ItemIndex;
end;

end.

