#ifndef ACCOUNT_H
#define ACCOUNT_H

#include <QtCore/QObject>
#include <QtGui/QImage>

#include "twitterapi/entry.h"

class Account
{

public:
    Account();
    void initialize(void);

    bool operator ==(const Account &other);

    UserInfo user;
    QImage avatar;

    QString token;
    QString tokenSecret;

    EntryList lastTweets;

    bool showAvatar;
    bool showUsername;
    bool showTimestamp;
    bool showReplyTo;
    bool highlightUrls;
    bool highlightMentions;
    bool highlightTags;

    void setUsername(QString username);
    QString getUsername();

    void setTokens(QString t, QString tSecret);
    QString getTokenString();
};

#endif // ACCOUNT_H

Q_DECLARE_METATYPE(Account)

QDataStream& operator<<( QDataStream &out, const Account &entry );
QDataStream& operator>>( QDataStream &in, Account &entry );


