/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef OAUTHWIZARD_H
#define OAUTHWIZARD_H

#include <QDesktopServices>

#include <QtOAuth/QtOAuth>

#include "applicationItems/twitterapplicationitem.h"
#include "applicationItems/twitterbutton.h"
#include "applicationItems/lineedit.h"

#include "account/accountManager.h"

#ifdef Q_WS_MAEMO_5
    #include <QMaemo5InformationBox>
#endif

typedef struct {
    QString screenName;
    QString token;
    QString tokenSecret;
}AuthorizedAccount;

class OauthWizard : public TwitterApplicationItem
{
    Q_OBJECT

public:
    OauthWizard(QGraphicsWidget *parent);
    static const QByteArray ConsumerKey;
    static const QByteArray ConsumerSecret;

public slots:
    void startAnimation(void);

private slots:
    void _exitAnimation(void);
    void _openUrl(void);
    void _enableButton(void);
    void _authorize(void);
    void _saveTokens(void);
    void _changeOrientation(void);

protected:
    void mousePressEvent(QGraphicsSceneMouseEvent *event);

signals:
    void newAccount(void);

private:
    void _authSteps(int step);

private:
    QList <AuthorizedAccount> accounts;
    QGraphicsRectItem *_bg;
    QGraphicsLineItem *_sep1;
    QGraphicsLineItem *_sep2;
    QGraphicsLineItem *_sep3;
    QGraphicsTextItem *_title;
    QGraphicsTextItem *_text1;
    QGraphicsTextItem *_text2;
    TwitterButton *_backButton;
    TwitterButton *_finishButton;
    TwitterButton *_allowButton;
    TwitterButton *_validateButton;
    LineEdit *_pinEntry;
    QPointF _startPos;
    QPointF _endPos;
    bool _anim;
    QFont font;
    int _step;

    QOAuth::Interface *qoauth;

    QByteArray screenName;
    QByteArray token;
    QByteArray tokenSecret;
    static const QByteArray TwitterRequestTokenURL;
    static const QByteArray TwitterAccessTokenURL;
    static const QByteArray TwitterAuthorizeURL;
    static const QByteArray ParamCallback;
    static const QByteArray ParamCallbackValue;
    static const QByteArray ParamVerifier;
    static const QByteArray ParamScreenName;
    static const QByteArray ParamToken;
    static const QByteArray ParamTokenSecret;
};

#endif // SETTINGS_H
