/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef TIMELINESETTINGS_H
#define TIMELINESETTINGS_H

#include "twitterapplicationitem.h"
#include "applicationItems/twitterbutton.h"

class TimelineSettings : public TwitterApplicationItem
{
    Q_OBJECT

public:
    TimelineSettings(QGraphicsWidget *parent);

private:
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget);
    void mousePressEvent(QGraphicsSceneMouseEvent *event);

signals:
    void logout(void);

private slots:
    void _changeOrientation(void);

public slots:
    void startAnimation(void);

private slots:
    void _exitAnimation(void);
    void _logout(void);

private:
    TwitterButton *_logoutButton;
    TwitterButton *_backButton;
    QGraphicsLineItem *_sep1;
    QGraphicsTextItem *_infos;
    QPointF _startPos;
    QPointF _endPos;
    bool _anim;
};

#endif // TIMELINESETTINGS_H
