/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef TWITTERTOPBAR_H
#define TWITTERTOPBAR_H

#include <QtGui/QFileDialog>

#include <QtNetwork>

#include "twitterapplicationitem.h"
#include "imagedownload.h"
#include "twitterbutton.h"
#include "kineticlist.h"
#include "backend.h"

/*! \class TwitterTopBar
 * \brief TwitterTopBar class
 * Handles all operations related to the topbar.
 */
class TwitterTopBar : public TwitterApplicationItem
{
    Q_OBJECT

public:
    TwitterTopBar(QGraphicsWidget *parent);

private slots:
    void _imageReady(QString);
    void _download(QString url);
    void _positions(void);

signals:
    void changeAvatar(QString);
    void settings(void);
    void refresh(void);
    void toHome(void);
    void toMentions(void);

private:
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *);
    void saveImage(void);
    UserInfo getUserInformation(void);

private:
    QGraphicsTextItem *_name;
    QRectF *_rect;
    QList<QPointF> listPositions;
    QImage defaultAvatar;
    QImage m_avatar;
    QImage followingImage;
    QImage followersImage;
    QImage tweetsImage;
    TwitterButton *_refreshButton;
    TwitterButton *_homeButton;
    TwitterButton *_mentionsButton;
    KineticList *_buttonsList;
    UserInfo user;
    QFont font;
    QString _imageUrl;
    QGraphicsPixmapItem *m_settingsIco;

public slots:
    void updateTopBar();

protected:
    void mousePressEvent(QGraphicsSceneMouseEvent *event);
};
#endif // TWITTERTOPBAR_H
