/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef TWITTERTWEETINFO_H
#define TWITTERTWEETINFO_H

#include "applicationItems/twitterapplicationitem.h"
#include "applicationItems/twitterbutton.h"
#include "applicationItems/twittertopbar.h"
#include "applicationItems/tweet.h"
#include "twitpic.h"

#include "twitterapi/entry.h"

/*!
 * \class TwitterTweetInfo
 *
 * \brief TwitterTweetInfo class handles all operations related to timelines
 */
class TwitterTweetInfo : public TwitterApplicationItem
{
    Q_OBJECT

public:
    TwitterTweetInfo(Tweet *tweet, bool atHomeTimeline,QGraphicsWidget *parent=0);
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *);
    void updateTweetInfo(QString type, bool update);
    QString getTwitPicUrl(void);
    QString getTweetPhotoUrl(void);

protected:
    void mousePressEvent(QGraphicsSceneMouseEvent *event);

signals:
    void retweet(QString);
    void reply(QString, quint64);
    void del(quint64, Tweet*);
    void favorite(QString, bool);
    void unfollow(QString, bool);
    void imageUrl(TwitPic::Services service);

public slots:
    void startAnimation(void);

private slots:
    void _favoriteInfo(void);
    void _paintAvatar(void);
    void _reply(void);
    void _retweet(void);
    void _deleteTweet(void);
    void _unfollow(void);
    void _loadMap(void);
    void _handleImageUrl(void);
    void _exitAnimation(void);

private:
    void _createButtons(void);
    void _paintTweet(void);
    void _paintUrlsAndMaps(QStringList urls, QStringList coordinates);
    QString _shortUrl(QString url);
    QStringList _createUrls(QString text);
    bool haveTwitPic(QString m_tweetMessage);
    bool haveTweetPhoto(QString m_tweetMessage);

private:
    TwitterButton *m_deleteButton;
    TwitterButton *m_retweetButton;
    TwitterButton *m_replyButton;
    TwitterButton *m_favoriteButton;
    TwitterButton *m_buttonGoToUrl;
    TwitterButton *m_unfollowButton;
    TwitterButton *m_twitPicButton;
    TwitterButton *m_backButton;
    Tweet *_tweet;

    Entry _entry;

    QString     m_tweetMessage;
    QString     m_tweetId;
    QString     m_username;
    QString     m_coordinates;
    QString     m_twitPicUrl;
    QString     m_tweetPhotoUrl;
    QStringList m_tweetUrls;
    bool        m_isMyTweet;
    bool        m_favorite;
    bool        m_isFollowing;
    bool        m_atHomeTimeline;
    bool        m_isTwitPic;
    bool        m_isTweetPhoto;
    QImage      m_image;
    QImage      m_defaultImage;
    QFont       font;
    QGraphicsLineItem *m_sep1;
    QGraphicsLineItem *m_sep2;
    QGraphicsTextItem *m_tweetText;
    QGraphicsTextItem *m_message;
    QGraphicsPixmapItem *m_favorited;
    QGraphicsPixmapItem *m_rtImage;
};

#endif // TWITTERTWEETINFO_H
