/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef LOGINVIEW_H
#define LOGINVIEW_H

#include <QtCore/QPair>
#include <QtCore/QPropertyAnimation>
#include <QtCore/QSequentialAnimationGroup>
#include <QtCore/QAbstractAnimation>

#include <QtGui/QColor>
#include <QtGui/QPainter>
#include <QtGui/QPainterPath>
#include <QtGui/QFont>
#include <QtGui/QGraphicsScene>
#include <QtGui/QGraphicsPixmapItem>
#include <QtGui/QPixmap>
#include <QtGui/QImage>
#include <QtGui/QLineEdit>
#include <QtGui/QGraphicsProxyWidget>
#include <QtGui/QPushButton>
#include <QtGui/QCheckBox>

#include "applicationItems/twittercheckbox.h"
#include "applicationItems/lineedit.h"
#include "applicationItems/loader.h"
#include "applicationItems/twitterbutton.h"

/*!
 * \class LoginView
 *
 * \brief Login window with customized widgets.
 */
class LoginView : public QGraphicsWidget
{
    Q_OBJECT

public:
    void createUi(void);
    LoginView(void);
    ~LoginView();
    bool getRememberMe(void);
    void setPassword(const QString &passwd);
    void setRememberMe(bool remember);
    void setUsername(const QString &username);
    QString getUsername(void);
    QString getPassword(void);
    TwitterButton *_cancelButton;

public slots:
    void connected(void);
    void connectionError(void);

private slots:
    void _connecting(void);
    void _deleteLoader();
    void _exitAnimationFinished(void);
    void _emitExitLogin(void);
    void _emitLoginAccount(void);
    void _checked(void);
    void _endLogin(void);

signals:
    void exitLogin(void);
    void loginAccount(void);
    void rememberMe(void);
    void done(void);
    void abort(void);

private:
    QAbstractAnimation *_createEntryAnimation(void);
    QAbstractAnimation *_createExitAnimation();
    void _createEntries(void);
    void _createLabels(void);
    void _createCheckbox(void);
    void _createButtons(void);
    void _createLogo(void);
    void _createLoginBackground(void);
    void _addOpacityAnim(QParallelAnimationGroup *anim,
                         TwitterApplicationItem *item,
                         int delay);
    void _addPosAnim(QParallelAnimationGroup *anim,
                     TwitterApplicationItem *item,
                     QPointF startValue, QPointF endValue,
                     QEasingCurve easing, int delay);

private:
    QAbstractAnimation *_exitAnim;
    QAbstractAnimation *_entryAnim;
    TwitterApplicationItem *_background;
    TwitterApplicationItem *_labelID;
    TwitterApplicationItem *_labelPassword;
    TwitterApplicationItem *_logo;
    TwitterApplicationItem *_checkboxLabel;
    TwitterButton *_loginButton;
    Loader *_loader;
    LineEdit *_entryID;
    LineEdit *_entryPassword;

public:
    TwitterCheckBox *checkbox;
    TwitterButton *_exitButton;
};

#endif // LOGINVIEW_H
