/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef TWITTERTWEETINFO_H
#define TWITTERTWEETINFO_H

#include <QtCore/QObject>
#include <QtCore/QRectF>
#include <QtCore/QListIterator>
#include <QtCore/QString>

#include <QtGui/QStyleOptionGraphicsItem>
#include <QtGui/QGraphicsSceneMouseEvent>
#include <QtGui/QGraphicsWidget>
#include <QtGui/QPixmap>
#include <QtGui/QPainter>
#include <QtGui/QDesktopServices>
#include <QtGui/QImage>
#include <QtGui/QFontMetrics>

#include <QtNetwork>

#include "twitterapplicationitem.h"
#include "twitterbutton.h"
#include "twittertimeline.h"
#include "twittertopbar.h"

/*!
 * \class TwitterTweetInfo
 *
 * \brief TwitterTweetInfo class handles all operations related to timelines
 */
class TwitterTweetInfo : public TwitterApplicationItem
{
    Q_OBJECT

public:
    TwitterTweetInfo(TwitterTimeline *timeline, TwitterTopBar *topBar, QGraphicsWidget *parent);
    ~TwitterTweetInfo(void);
    QList<QImage> orderUserImages(QList<QImage>);

    QString getRetweet(int postion);
    QString getUsername(int position);
    QString getStatusId(int position);
    QList<QString> parseSource(QList<QString> source);
    void createUi(void);
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *);
    void _labelPositions(void);
    QStringList _createUrls();

    TwitterButton *_unfollowButton;
    bool unfollowCreated(void);

signals:
    void finished(void);
    void profile(void);
    void retweet(void);
    void reply(void);
    void del(void);
    void favorite(QString);
    void unfollow(void);

    void backToTimeLine(void);

private slots:
    void goToUrl(QString);

    void favoriteInfo(void);


private:
    int numberOfUrls;
    void _createButtons(void);
    TwitterButton *_deleteButton;
    TwitterButton *_retweetButton;
    TwitterButton *_replyButton;
    TwitterButton *_favoriteButton;
    TwitterButton *_buttonGoToUrl;

    TwitterButton *_backButton;

    QStringList _listUrls;
    int numberOfDownloadedUrls;
    bool paintImages;
    QString _tweetName;
    QString _tweetText;
    QString _tweetUrl;
    QString _tweetId;
    QString _tweetSource;
    QString _tweetCreatedAt;
    QImage _tweetUserImage;
    QString _username;
    TwitterButton *_urlButton;

    bool _favorite;
    QFont font;
    QFont font2;
};

#endif // TWITTERTWEETINFO_H
