/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef LINEEDIT_H
#define LINEEDIT_H

#include <QtCore/QRectF>
#include <QtCore/QObject>
#include <QtCore/QString>

#include <QtGui/QLineEdit>
#include <QtGui/QFont>
#include <QtGui/QGraphicsPixmapItem>
#include <QtGui/QGraphicsPathItem>
#include <QtGui/QGraphicsProxyWidget>
#include <QtGui/QGraphicsSceneMouseEvent>
#include <QtGui/QPainter>
#include <QtGui/QPalette>
#include <QtGui/QPainterPath>
#include <QtGui/QPixmap>

#include "twitterapplicationitem.h"


/*!
 * \class FocusLine
 *
 * \brief Creates an outline for a focused object.
 */
class FocusLine : public QGraphicsPathItem
{

public:
    FocusLine(int width, int height, QGraphicsItem *parent = 0)
            : QGraphicsPathItem(parent) {
        QPen pen;
        pen.setWidth(3);
        pen.setBrush(QColor(15, 149, 218));
        pen.setCapStyle(Qt::RoundCap);
        pen.setJoinStyle(Qt::RoundJoin);

        QPainterPath path;
        path.addRoundedRect(0, 0, width, height, 3, 3);

        setPen(pen);
        setBrush(Qt::NoBrush);
        setPath(path);
    }

    ~FocusLine() {
    }

    void paint(QPainter *painter,
               const QStyleOptionGraphicsItem *option,
               QWidget * widget) {
        painter->setRenderHint(QPainter::Antialiasing);

        QGraphicsPathItem::paint(painter, option, widget);
    }

};

/*!
 * \class LineEditBox
 *
 * \brief Inherits from QLineEdit and implements
 * a clicked signal.
 */
class LineEditBox : public QLineEdit
{
    Q_OBJECT

public:
    LineEditBox()
            : QLineEdit() {
    }

    ~LineEditBox() {
    }

protected:
//    void mousePressEvent(QMouseEvent *event) {
//        Q_UNUSED(event);
//
//        emit clicked();
//    }

    void mouseDoubleClickEvent(QMouseEvent *event) {
        Q_UNUSED(event);

        emit doubleClicked();
    }

    void focusInEvent(QFocusEvent *event) {
        //Q_UNUSED(event);
        QLineEdit::focusInEvent(event);

        emit gainedFocus();
    }

    void focusOutEvent(QFocusEvent *event) {
//        Q_UNUSED(event);
        QLineEdit::focusOutEvent(event);

        emit lostFocus();
    }

signals:
    void clicked(void);
    void gainedFocus(void);
    void lostFocus(void);
    void doubleClicked(void);

};

/*!
 * \class LineEdit
 *
 * \brief Creates a graphical entry box
 * that can be added to a QGraphicsScene.
 */
class LineEdit : public TwitterApplicationItem
{
    Q_OBJECT

public:
    enum TypeLineEdit{ Short, Long };

    LineEdit(LineEdit::TypeLineEdit type , QGraphicsWidget *parent = 0);
    ~LineEdit();

    void setEchoMode(QLineEdit::EchoMode echo);
    void mousePressEvent(QGraphicsSceneMouseEvent *event);
    void mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event);
    void keyPressEvent(QKeyEvent *event);
    void createBackground(void);
    void createFocus(void);
    void createEntry(void);

    void setCursorPosition(int pos);
    int getTextLength(void);
    void setTextLength(int newSize);

    QGraphicsProxyWidget *getEntry(void);

    QRectF boundingRect() const {
        return _image->boundingRect();
    }

    QPainterPath shape() const {
        QPainterPath path;
        path.addRoundedRect(boundingRect(), 25, 25);
        return path;
    }

public slots:
    void selectAll(void);
    void gainedFocus(void);
    void lostFocus(void);
    void keepImage(void);

signals:
    void sizeText(int);
    void key(void);
    void enterPressed(void);

protected:
    int size;

    void keyReleaseEvent(QKeyEvent *event) {
        Q_UNUSED(event);
        size = _entryWidget->text().length();
        emit sizeText(size);
        emit key();
        update();
    }

private:
    QGraphicsPixmapItem *_image;
    FocusLine *_focusLine;
    QGraphicsProxyWidget *_entry;
    LineEditBox *_entryWidget;
    int _type;
};

#endif

