/*
 * vim:ts=4:sw=4:et:cindent:cino=(0
 */ 

#ifndef __TWEAKR_MODULE_H__
#define __TWEAKR_MODULE_H__

#include <glib-object.h>

G_BEGIN_DECLS


#define TWEAKR_TYPE_MODULE \
        (tweakr_module_get_type ())
#define TWEAKR_MODULE(o) \
        (G_TYPE_CHECK_INSTANCE_CAST ((o), TWEAKR_TYPE_MODULE, \
        TweakrModule))
#define TWEAKR_MODULE_CLASS(k) \
        (G_TYPE_CHECK_CLASS_CAST((k), TWEAKR_TYPE_MODULE, \
        TweakrModuleClass))
#define TWEAKR_IS_MODULE(o) \
        (G_TYPE_CHECK_INSTANCE_TYPE ((o), TWEAKR_TYPE_MODULE))
#define TWEAKR_IS_MODULE_CLASS(k) \
        (G_TYPE_CHECK_CLASS_TYPE ((k), TWEAKR_TYPE_MODULE))
#define TWEAKR_MODULE_GET_CLASS(o) \
        (G_TYPE_INSTANCE_GET_CLASS ((o), TWEAKR_TYPE_MODULE, \
        TweakrModuleClass))

typedef struct _TweakrModule      TweakrModule;
typedef struct _TweakrModuleClass TweakrModuleClass;

struct _TweakrModule
{
    GTypeModule  parent_instance;

    gchar       *filename;
    GModule     *library;

    /*  module symbols  */
    void (* load)   (TweakrModule *module);
    void (* unload) (TweakrModule *module);
};

struct _TweakrModuleClass
{
    GTypeModuleClass  parent_class;
};

GType tweakr_module_get_type (void) G_GNUC_CONST;

TweakrModule * tweakr_module_new      (const gchar *filename);


/* API for the modules to implement */

void        tweakr_module_load     (TweakrModule   *module);
void        tweakr_module_unload   (TweakrModule   *module);


G_END_DECLS

#endif /* __TWEAKR_MODULE_H_ */
