#! /usr/bin/python
# -*- coding: utf-8 -*-
# Mikael Honkala

import urllib, urllib2
import base64
from xml.dom import minidom
import os
import sys
import time, calendar
import stat
import gtk, hildon
import pickle
import gobject
import feedparser
import i18n
import dbus
from threading import Timer

_ = i18n.language.gettext

# mplayer -fs True-Blood--K15-_2010.09.17_YLE-TV2_6842662\ pienin.mp4 -sub True-Blood--K15-_2010.09.17_YLE-TV2_6842662.srt -utf8

gtk.gdk.threads_init()

#videoformat = 'video/mp4'
#videobitrate = '300'
subtitleformat = 'application/x-srt'
format_list = [ ( _("Pienin (mono)"), "video/mp4", "300" ),
                ( _("Laadukkaampi (stereo)"), "video/mp4", "2000" ),
                ( _("Alkuperäinen (stereo)"), "video/mp2t", "8000" ) ]
selected_format = 0

# Haetun tiedoston loppuun lisättävä liite - .mpg on paremmin tunnistettava kuin .ts
# Jos et halua lisäliitettä, voit muuttaa tyhjäksi
#additionalExtension = '.mpg'
additionalExtension = ''

# TVKaista säilyttää ohjelmat 4 viikkoa - voisi olla konfiguroitava
weeks_to_retain_shows = 4
seconds_in_a_week = 7 * 24 * 60 * 60
duration_for_retaining_shows = weeks_to_retain_shows * seconds_in_a_week

# Ladattavat tiedostot talletetaan oletusarvoisesti samaan hakemistoon missä tämä .py tiedosto on. Tähän voi laittaa vaihtoehtoisen polun.
saveDirectory = './'
configDirectory = os.path.expanduser("~/MyDocs/.tvkaista-fetch/")
logDirectory = configDirectory + 'Log/'
infoDirectory = configDirectory + 'Info/'

# Näitä voi säätää, jos feedit taas muuttuvat
server = 'http://alpha.tvkaista.fi/feed'
suosikit = '/playlist'
sarjat = '/seasonpasses'
haku = '/search/title/'

# Ei säädettävää tästä eteenpäin
username = ''
password = ''
feeds = []
config = None
selected = []
searches = []
favorites = []
seasonpasses = []
win = None
selector = None
videodir = ""

ALL = 0
NEW = 1
LOADED = 2
display_filter = ALL

# Hakufunktio feedeille, hoitaa autentikoinnin

def getUrl(url):
  global config
  username, password = config['auth']
  return getUrlWithAuth(url, username, password)

def getUrlWithAuth(url, testusername, testpassword) :
  req = urllib2.Request(url);
  base64string = base64.encodestring('%s:%s' % (testusername, testpassword))[:-1]
  authheader =  "Basic %s" % base64string
  req.add_header("Authorization", authheader)
  return urllib2.urlopen(req)

def sync_status(message):
  hildon.hildon_banner_show_information(win, "", message)
  while gtk.events_pending() :
    gtk.main_iteration(False)

def get_and_clean_show_info(mark_as_old = True, clean_all_unloaded = False) :
  fetchFiles = []
  nowtime = time.time()
  dirlists = os.walk(infoDirectory)
  for dirlist in dirlists :
    dirpath, dirnames, filenames = dirlist
    if dirpath == infoDirectory :
      for filename in filenames :
        infoPack = info_from_file(filename)
        (timestamp, titlestr, descriptionstr, videourl, subtitleurl, filename, subfilename, size) = infoPack
        # Remove old show information, if not downloaded
        if not os.path.exists(saveDirectory + filename) :
          showtime = time.mktime(timestamp)
          if ((nowtime - showtime) > duration_for_retaining_shows) or clean_all_unloaded :
            os.remove(infoDirectory + filename)
            if os.path.exists(logDirectory + filename) :
              os.remove(logDirectory + filename)
            continue
        fetchFiles.append(infoPack)
        # Mark all remaining shows as old
        if mark_as_old and (not os.path.exists(logDirectory + filename)) :
          logfile = open(logDirectory + filename, "w")
          logfile.close()
  fetchFiles.sort()
  fetchFiles.reverse()
  return fetchFiles

def fetch_show_info(display_area) :
  global config, feeds, favorites, seasonpasses

  display, videoformat, videobitrate = format_list[selected_format]

  fetchFiles = feeds

  baseFeeds = []
  favorites = []
  seasonpasses = []

  sync_status(_("Paivitetaan ohjelmatiedot"))

  # Suosikkilista haetaan ainakin
  baseFeeds.append(server + suosikit)

  # Haetaan avainsanahaut, jos niitä on
  if 'searches' in config :
    for search in config['searches'] :
      baseFeeds.append(server + haku + urllib.quote(search))

  sync_status(_("Haetaan sarjalista"))

  # Haetaan sarjakohtaiset syötteet
  rss = minidom.parse(getUrl(server + sarjat))
  for node in rss.getElementsByTagName('item') :
    baseFeeds.append(node.getElementsByTagName('link')[0].firstChild.data)
    seasonpasses.append(node.getElementsByTagName('title')[0].firstChild.data)
  config['seasonpasses'] = seasonpasses
  config_to_file(config)

  sync_status(_("Haetaan ohjelmakohtaiset tiedot"))

  # Sitten haetaan kaikista feedeistä ohjelmakohtaiset Urlit
  for feed in baseFeeds:
    getting_favorites = False
    if feed == (server + suosikit) :
      getting_favorites = True
    try :
      rss = minidom.parse(getUrl(feed + '/ts.mediarss'))
      prev_title = ""
      for node in rss.getElementsByTagName('item') :
        timestampstr = node.getElementsByTagName('pubDate')[0].firstChild.data
        timetuple = feedparser._parse_date(timestampstr)
        gmtime = calendar.timegm(timetuple)
        timestamp = time.localtime(gmtime)
        mediaelem = node.getElementsByTagName('media:group')
        if not mediaelem : continue
        media = mediaelem[0]
        titlestr = media.getElementsByTagName('media:title')[0].firstChild.data
        if titlestr != prev_title :
          if getting_favorites :
            favorites.append(titlestr)
            config['favorites'] = favorites
            config_to_file(config)
          sync_status(_("Haetaan tiedot: %s") % titlestr)
        prev_title = titlestr
        descriptionstr = _("Ohjelmasta ei saatavilla kuvausta")
        mediaElement = media.getElementsByTagName('media:description')
        if mediaElement :
          descriptionstr = mediaElement[0].firstChild.data
        videourl = None
        subtitleurl = None
        for content in media.getElementsByTagName('media:content') :
          mediatype = content.getAttribute('type')
          if mediatype == videoformat :
            if content.getAttribute('bitrate') == videobitrate :
              videourl = content.getAttribute('url')
              size = content.getAttribute('fileSize')
          if mediatype == subtitleformat :
            subtitleurl = content.getAttribute('url')
        if videourl :
          urlObject = getUrl(videourl)
          redirectedUrl = urlObject.geturl()
          filename = redirectedUrl.split('outputfilename=')[1]
          urlObject.close()
          subfilename = None
          if subtitleurl :
            try :
              urlObject = getUrl(subtitleurl)
              redirectedUrl = urlObject.geturl()
#              subfilename = urlObject.geturl().split('outputfilename=')[1]
              subfilenameparts = os.path.splitext(filename)
              subfilename = subfilenameparts[0] + '.srt'
              urlObject.close()
            except Exception, e :
              sync_status(_("Tekstitystiedostovirhe: %s") % str(e))
              print sys.exc_info()
            if not subfilename :
              subfilename = "error"
#          logFilename = logDirectory + filename
          if not os.path.exists(logDirectory) :
            os.makedirs(logDirectory)
          infoPack = (timestamp, titlestr, descriptionstr, videourl, subtitleurl, filename, subfilename, size)
          if not os.path.exists(infoDirectory + filename) :
            info_to_file(infoPack, filename)
            feeds.append(infoPack)
            feeds.sort()
            feeds.reverse()
            create_selector(display_area)
            gtk.main_iteration()
    except Exception, e :
      sync_status(_("Latausvirhe: %s") % str(e))
      print sys.exc_info()
  config['favorites'] = favorites
  config_to_file(config)
  return fetchFiles

cancel = False

def download_files(widget, display_area) :
  global selected, feeds, win, videodir, cancel
  blocksize = 1000000
  if len(selected) > 0 :
    for index, row_selected in enumerate(selected) :
      if row_selected :
        downloadsize = 0
        timestamp, name, descr, vurl, surl, filename, subfilename, size = feeds[index]
        partialSaveFilename = videodir + filename + '.partial'
        try :
          pbar = gtk.ProgressBar()
          pbar.set_fraction(0.0)
          dialog = gtk.Dialog(_("Ladataan %s") % name, win)
          dialog.vbox.pack_end(pbar, False, False)
          playbutton = create_button(_(" Katso nyt "), None, None, watch_while_loading, partialSaveFilename)
          cancelbutton = create_button(_("  Lopeta  "), None, None, cancel_load)
          dialog.action_area.add(playbutton)
          dialog.action_area.add(cancelbutton)
          dialog.show_all()
          while gtk.events_pending() :
            gtk.main_iteration()
          urlObject = getUrl(vurl)
          saveFilename = videodir + filename + additionalExtension
          savefile = open(partialSaveFilename, "w")
          while True :
            block = urlObject.read(blocksize)
            if block == '':
              break
            savefile.write(block)
            downloadsize += blocksize
            pbar.set_fraction(min(float(downloadsize)/float(size), 1.0))
            while gtk.events_pending() :
              gtk.main_iteration()
            if cancel :
              cancel = False
              dialog.destroy()
              savefile.close()
              if os.path.exists(partialSaveFilename) :
                os.remove(partialSaveFilename)
              return
            time.sleep(0.2)
          savefile.close()
          dialog.destroy()
          os.rename(partialSaveFilename, saveFilename)
          os.chmod(saveFilename, stat.S_IRUSR | stat.S_IWUSR | stat.S_IRGRP | stat.S_IWGRP | stat.S_IROTH)
          if surl and not (subfilename == "error") :
            urlObject = getUrl(surl)
            partialSaveFilename = videodir + subfilename + '.partial'
            saveFilename = videodir + subfilename
            savefile = open(partialSaveFilename, "w")
            savefile.write(urlObject.read(blocksize))
            savefile.close()
            os.rename(partialSaveFilename, saveFilename)
            os.chmod(saveFilename, stat.S_IRUSR | stat.S_IWUSR | stat.S_IRGRP | stat.S_IWGRP | stat.S_IROTH)
          # Log successful download
          logfile = open(logDirectory + filename, "w")
          logfile.close()
        except urllib2.HTTPError, e :
          sync_status(_("Latausvirhe: %s") % str(e))
    create_selector(display_area)

def cancel_load(widget) :
  global cancel
  cancel = True

def watch_it(widget, index, stream = False) :
  global feeds
  timestamp, name, descr, vurl, surl, filename, subfilename, size = feeds[index]
  if stream :
    filename = vurl
  play_it(filename, stream)

def watch_while_loading(widget, filename) :
  player = get_player()
  player.mime_open('file:///%s' % filename)

def play_it(filename, stream = False) :
  player = get_player()
  if stream :
    try :
      urlObject = getUrl(filename)
      redirectedUrl = urlObject.geturl()
#      print redirectedUrl
      player.mime_open(redirectedUrl)
    except urllib2.HTTPError, e :
      sync_status(_("Latausvirhe: %s") % str(e))
  else :
    if not os.path.exists(videodir + filename) :
      sync_status(_("Valittua ohjelmaa ei ole ladattu"))
    else :
      player.mime_open('file:///%s' % (videodir + filename))

def get_player() :
  session_bus = dbus.SessionBus()
  proxy = session_bus.get_object('com.nokia.mediaplayer', '/com/nokia/mediaplayer')
  return dbus.Interface(proxy, 'com.nokia.mediaplayer')

def do_refresh(widget, display_area, clean = False) :
  global win, feeds, config
  feeds = get_and_clean_show_info(clean_all_unloaded = clean) # From local files
  feeds = fetch_show_info(display_area) # From TVKaista

def add_to(table, widget, row, column, width_options=None) :
  xopt = gtk.FILL|gtk.EXPAND
  if width_options :
    xopt = width_options
  table.attach(widget, row, row+1, column, column+1, xoptions=xopt)

def create_selector(display_area) :
  global feeds, selected, selector, win, display_filter
  alloc = win.get_allocation()
  if selector : selector.destroy()
  if len(feeds) > 0 :
    table = gtk.Table(len(feeds), 3)
    table.set_size_request(alloc.width, -1)
  selected = []
  index = -1
  visible = 0
  for infoPack in feeds :
    (timestamp, name, descr, vurl, surl, filename, subfilename, size) = infoPack
    index += 1
#    selected.append(not os.path.exists(logDirectory + filename))
    selected.append(False)
    if display_filter == NEW and os.path.exists(logDirectory + filename) :
      continue
    if display_filter == LOADED and not os.path.exists(videodir + filename) :
      continue
    visible += 1
    icon_name = ""
    if selected[index] :
      icon_name = "clock_alarm_on"
    else :
      icon_name = "clock_alarm_off"
    togglebutton = create_button("", None, icon_name, toggle_selected, index)
    togglebutton.set_relief(gtk.RELIEF_NONE)
    add_to(table, togglebutton, 0, index)
    timestr = time.strftime("%d.%m.", timestamp)
    displaystr = "%s - %s" % (timestr, name)
    imagestr = None
    if not os.path.exists(logDirectory + filename):
      imagestr = 'imageviewer_favourite'
    button = create_button(displaystr, descr, imagestr, create_info_window, infoPack)
    button.set_relief(gtk.RELIEF_NONE)
    button.set_alignment(0, 0, 0, 0)
    add_to(table, button, 1, index, gtk.FILL|gtk.SHRINK)
    if os.path.exists(videodir + filename) :
      button = create_button("", None, 'camera_playback', watch_it, index)
    else :
      button = create_button("", None, 'camera_scene_mode_sport', watch_it, index, True)
    button.set_relief(gtk.RELIEF_NONE)
    add_to(table, button, 2, index)
#    elif not os.path.exists(logDirectory + filename) :
#      image = gtk.Image()
#      image.set_from_icon_name('imageviewer_favourite', gtk.ICON_SIZE_BUTTON)
#      add_to(table, image, 2, index)
  if visible > 4 :
    selector = hildon.PannableArea()
    selector.add_with_viewport(table)
    display_area.pack_start(selector, True, True)
  elif visible > 0 :
    selector = table
    display_area.pack_start(selector, False, False)
  else :
    if display_filter == ALL :
      selector = gtk.Label(_("Ei ohjelmatietoja"))
    elif display_filter == NEW :
      selector = gtk.Label(_("Ei uusia ohjelmia"))
    else :
      selector = gtk.Label(_("Ei ladattuja ohjelmia"))
    display_area.add(selector)
  display_area.show_all()

def toggle_selected(widget, index) :
  global selected
  image = gtk.Image()
  icon_name = ""
  if selected[index] :
    selected[index] = False
    icon_name = "clock_alarm_off"
  else :
    selected[index] = True
    icon_name = "clock_alarm_on"
  image.set_from_icon_name(icon_name, gtk.ICON_SIZE_BUTTON)
  widget.set_image(image)

#def toggle_proxy(widget, button) :
#  button.clicked()

def create_info_window(widget, infoPack) :
  (timestamp, name, descr, vurl, surl, filename, subfilename, size) = infoPack
  info_window = hildon.StackableWindow()
  info_window.set_title(name)
  info_window.show_all()
  gtk.main_iteration()
  alloc = info_window.get_allocation()
#  table = gtk.Table(len(feeds), 3)
#  table.set_size_request(alloc.width, -1)
  content = gtk.VBox(False, 10)
  namelabel = gtk.Label()
  namelabel.set_alignment(0, 0.0)
  namelabel.set_markup('<b>%s</b>' % name)
  numberslabel = gtk.Label()
  timestr = time.strftime("%c", timestamp) # "%A %d.%m.%y klo %h:M"
  sizemb = int(size) / (1024 * 1024)
  numberslabel.set_markup('<i>%s - %d Mb</i>' % (timestr, sizemb))
  numberslabel.set_alignment(0, 0.0)
  descrlabel = gtk.Label(descr)
  descrlabel.set_line_wrap(True)
  descrlabel.set_size_request(alloc.width, -1)
  descrlabel.set_alignment(0, 0.0)
  status = ''
  if not os.path.exists(logDirectory + filename) :
    status += _("Tama ohjelma on ollut uusi viimeisessa paivityksessa. ")
  if not os.path.exists(videodir + filename) :
    status += _("Ohjelman tiedostoja ei ole ladattuna talla laitteella. ")
  else:
    status += _("Ohjelman tiedostot on ladattu ja valmiina katsottavaksi. ")
  if surl :
    if subfilename == "error" :
      status += _("Ohjelmassa ei ole tekstitysta, koska tekstitystiedostoa ei loytynyt palvelimelta. ")
    else :
      status += _("Ohjelman tekstitys on erillisessa tiedostossa. Tekstityksen nakyminen vaatii Subtitles Support -paketin asennuksen ja kayton Unicode (UTF-8) -asetuksella. ")
  statuslabel = gtk.Label()
  statuslabel.set_markup('<i>%s</i>' % status)
  statuslabel.set_line_wrap(True)
  statuslabel.set_size_request(alloc.width, -1)
  statuslabel.set_alignment(0, 0.0)
  content.pack_start(namelabel, False, False)
  content.pack_start(numberslabel, False, False)
  content.pack_start(descrlabel, False, False)
  content.pack_start(gtk.HSeparator(), False, False)
  content.pack_start(statuslabel, False, False)
#  content.add(descrlabel)
  info_window.add(content)
  content.show_all()

def delete_files(widget, display_area) :
  global selected, feeds, videodir
  if len(selected) > 0 :
    count = 0
    for index, row_selected in enumerate(selected) :
      if row_selected :
        timestamp, name, descr, vurl, surl, filename, subfilename, size = feeds[index]
        videofile = videodir + filename
        if os.path.exists(videofile) :
          os.remove(videofile)
          count += 1
        if os.path.exists(videofile + '.partial') :
          os.remove(videofile + '.partial')
          count += 1
        if subfilename :
          subfile = videodir + subfilename
          if os.path.exists(subfile) :
            os.remove(subfile)
            count += 1
          if os.path.exists(subfile + '.partial') :
            os.remove(subfile + '.partial')
            count += 1
    if count == 0 :
      sync_status(_("Ei poistettavia tiedostoja valittuna"))
    else :
      sync_status(_("Tiedostoja poistettu: %s") % str(count))
    create_selector(display_area)

#def log_as_old(widget, display_area) :
#  global selected, feeds
#  if len(selected) > 0 :
#    for index, row_selected in enumerate(selected) :
#      if row_selected :
#        timestamp, name, descr, vurl, surl, filename, subfilename, size = feeds[index]
#        logFilename = logDirectory + filename
#        logfile = open(logFilename, "w")
#        logfile.close()
#    create_selector(display_area)

def show_search_window(widget, data=None) :
  global config, favorites, seasonpasses
  search_window = hildon.StackableWindow()
  search_window.set_title(_("Ohjelmien hakuehdot"))
  columns = gtk.HBox()
  topservercolumn = gtk.VBox()
  topservercolumn.pack_start(create_label(_("<b>Palvelimella</b>")), False, False)
  topservercolumn.pack_start(create_label(" "), False, False)
  area = hildon.PannableArea()
  servercolumn = gtk.VBox()
  area.add_with_viewport(servercolumn)
  topservercolumn.add(area)
  favoritesheadingtext = _("<i>Katselulista:</i>")
  if len(favorites) == 0 :
    favoritesheadingtext = _("<i>Ei mitaan katselulistalla</i>")
  servercolumn.pack_start(create_label(favoritesheadingtext), False, False)
  for favoritestr in favorites :
    servercolumn.pack_start(create_label(favoritestr), False, False)
  servercolumn.pack_start(create_label(" "), False, False)
  seasonpassheadingtext = _("<i>Sarjat:</i>")
  if len(seasonpasses) == 0 :
    seasonpassheadingtext = _("<i>Ei sarjoja valittuna</i>")
  servercolumn.pack_start(create_label(seasonpassheadingtext), False, False)
  for seasonpassstr in seasonpasses :
    servercolumn.pack_start(create_label(seasonpassstr), False, False)
  localcolumn = gtk.VBox()
  localcolumn.pack_start(create_label(_("<b>Paikalliset</b>")), False, False)
  larea = hildon.PannableArea()
  search_list = gtk.VBox()
  larea.add_with_viewport(search_list)
  if 'searches' in config :
    for search in config['searches'] :
      button = create_button(search, None, None, remove_search, (search, larea, search_list))
      button.set_relief(gtk.RELIEF_NONE)
      button.set_alignment(0, 0.5, 0, 0)
      search_list.pack_start(button, False, False)
  entry = hildon.Entry(gtk.HILDON_SIZE_FINGER_HEIGHT)
##  caption = hildon.Caption(None, "Haku", entry, None, True)
  add_button = create_button(_("Lisaa"), _("vapaa haku"), "general_add", add_search, (entry, search_list, larea))
  entry.connect('activate', add_search, (entry, search_list, larea))
  add_box = gtk.HBox()
  add_box.add(entry)
  add_box.pack_end(add_button, False, False)
  label = create_label(_("<i>Valitse rivi poistaaksesi sen</i>"))
  localcolumn.add(larea)
  localcolumn.pack_start(add_box, False, False)
  localcolumn.pack_end(label, False, False)
  columns.add(topservercolumn)
  columns.pack_start(gtk.VSeparator(), False, False)
  columns.add(localcolumn)
  search_window.add(columns)
  search_window.show_all()
  entry.grab_focus()

def add_search(widget, data) :
  global config
  entry, search_list, larea = data
  searches = []
  value = entry.get_text()
  if 'searches' in config :
    searches = config['searches']
  if value != '' :
    if value in searches :
      sync_status(_("Haku jo listalla"))
      return
    searches.append(value)
    config['searches'] = searches
    config_to_file(config)
    button = create_button(value, None, None, remove_search, (value, larea, search_list))
    button.set_relief(gtk.RELIEF_NONE)
    button.set_alignment(0, 0.5, 0, 0)
    button.connect("size_allocate", scroll_to_button, larea)
    search_list.pack_start(button, False, False)
    button.show()
    entry.set_text("")

def scroll_to_button(widget, event, larea) :
  alloc = widget.get_allocation()
  larea.scroll_to(-1, alloc.y + int(alloc.height/2))

def remove_search(widget, data) :
  global config
  search, larea, search_list = data
  alloc = widget.get_allocation()
  searches = []
  if 'searches' in config :
    searches = config['searches']
  searches.remove(search)
  config['searches'] = searches
  config_to_file(config)
  search_list.remove(widget)
  larea.scroll_to(-1, alloc.y)

def show_auth_dialog(widget) :
  global win
  dialog = gtk.Dialog(_("TVKaistan kayttooikeus - nykyista ei nayteta"), win)
  dialog.set_transient_for(win)
  uentry = hildon.Entry(gtk.HILDON_SIZE_FINGER_HEIGHT)
  pentry = hildon.Entry(gtk.HILDON_SIZE_FINGER_HEIGHT)
  group = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
  ucaption = hildon.Caption(group, _("Tunnus"), uentry, None, True)
  pcaption = hildon.Caption(group, _("Salasana"), pentry, None, True)
  dialog.vbox.add(ucaption)
  dialog.vbox.add(pcaption)
  save_button = create_button(_("Tallenna"), None, None, save_auth, (dialog, uentry, pentry))
  dialog.action_area.add(save_button)
  dialog.show_all()

def save_auth(widget, entries) :
  global config
  dialog, uentry, pentry = entries
  sync_status(_("Testataan yhteys"))
  try :
    getUrlWithAuth(server, uentry.get_text(), pentry.get_text())
    sync_status(_("Yhteys ok"))
    config['auth'] = ( uentry.get_text(), pentry.get_text())
    config_to_file(config)
    dialog.destroy()
  except urllib2.HTTPError, error :
    if error.code == 401 :
      sync_status(_("Tunnus/salasana ei kelpaa"))
    else:
      sync_status(str(error))

def show_dir_dialog(widget, display_area) :
  global win, config, videodir
  fc = gobject.new(hildon.FileChooserDialog, action=gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER)
#  fc.set_property('show-files',True)
  fc.set_current_folder(videodir)
  if fc.run() == gtk.RESPONSE_OK :
    videodir = fc.get_filename() + "/"
    config["videodir"] = videodir
    config_to_file(config)
  fc.destroy()
  create_selector(display_area)

def create_button(title, value, stock_icon, function, *args) :
  button = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, title)
  if value :
    button.set_value(value)
  if stock_icon :
    image = gtk.Image()
    if isinstance(stock_icon, str) :
      image.set_from_icon_name(stock_icon, gtk.ICON_SIZE_BUTTON)
    else :
      image.set_from_stock(stock_icon, gtk.ICON_SIZE_BUTTON)
    button.set_image(image)
  if function :
    button.connect("clicked", function, *args)
  return button

def create_label(text=None, markup=True, leftalign=True) :
 label = gtk.Label()
 if leftalign :
   label.set_alignment(0, 0)
 if label :
   if markup :
     label.set_markup(text)
   else :
     label.set_text(text)
 return label

def config_to_file(obj) :
  if not os.path.exists(configDirectory) :
    os.makedirs(configDirectory)
  savefile = open(configDirectory + 'TVKaista.cfg', "w")
  pickle.Pickler(savefile, pickle.HIGHEST_PROTOCOL).dump(obj)
  savefile.close()

def config_from_file() :
  try :
    loadfile = open(configDirectory + 'TVKaista.cfg', "r")
    return pickle.Unpickler(loadfile).load()
  except :
    return None
#  finally :
#    loadfile.close()

def info_to_file(infoPack, filename) :
  if not os.path.exists(infoDirectory) :
    os.makedirs(infoDirectory)
  savefile = open(infoDirectory + filename, "w")
  pickle.Pickler(savefile, pickle.HIGHEST_PROTOCOL).dump(infoPack)
  savefile.close()

def info_from_file(filename) :
  try :
    loadfile = open(infoDirectory + filename, "r")
    return pickle.Unpickler(loadfile).load()
  except :
    return None

def set_display_filter(widget, data):
  global display_filter
  display_filter, display_area = data
  config['display_filter'] = display_filter
  config_to_file(config)
  create_selector(display_area)

processing = False

def set_format(widget, column, displayarea) :
  global selected_format, processing, feeds
  if processing :
    return
  processing = True
  new = widget.get_active(column)
  if new != selected_format :
    conf_message =  "Tiedostomuodon vaihtaminen edellyttää ohjelmatietojen hakemista palvelimelta uudelleen. Laitteelle haettuja ohjelmatiedostoja ei poisteta. Vaihdetaanko tiedostomuoto?"
    note = hildon.Note("confirmation", widget.get_parent().get_parent().get_parent().get_parent(), conf_message)
    retcode = gtk.Dialog.run(note)
    note.destroy()
    if retcode == gtk.RESPONSE_OK :
      selected_format = new
      config['selected_format'] = selected_format
      config_to_file(config)
      do_refresh(widget, displayarea, clean=True)
    else:
      widget.set_active(column, selected_format)
  processing = False

def main():
  global win, black_pixbuf, config, feeds, videodir, display_filter, favorites, seasonpasses, selected_format
  win = hildon.StackableWindow()
  win.set_title(_("TVKaistan noutaja"))
  config = config_from_file()
  if config == None :
    config = {}
    show_auth_dialog(None)
  if 'videodir' in config :
    videodir = config['videodir']
  else :
    videodir = os.path.expanduser("~/MyDocs/.videos/")
    config['videodir'] = videodir
  if 'display_filter' in config :
    display_filter = config['display_filter']
  if 'favorites' in config :
    favorites = config['favorites']
  if 'seasonpasses' in config :
    seasonpasses = config['seasonpasses']
  if 'selected_format' in config :
    selected_format = config['selected_format']
  else :
    config['selected_format'] = selected_format
  config_to_file(config)
  column = gtk.VBox()
  top_buttons = gtk.HBox()
  check_new_button = create_button(_("Paivita"), _("ohjelmatiedot palvelusta"), "general_refresh", do_refresh, column)
  edit_search_button = create_button(_("Haut"), None, "general_search", show_search_window, None)
  top_buttons.add(check_new_button)
  top_buttons.add(edit_search_button)
  column.pack_start(top_buttons, False, False)
  column.pack_start(gtk.HSeparator(), False, False)
  buttons = gtk.HBox()
  download_button = create_button(_("Lataa"), _("valitut"), "keyboard_move_down", download_files, column)
  delete_button = create_button(_("Poista"), _("valittujen ladatut tiedostot"), "camera_delete", delete_files, column)
  buttons.add(delete_button)
  buttons.add(download_button)
  column.pack_end(buttons, False, False)
  column.pack_end(gtk.HSeparator(), False, False)
  menu = hildon.AppMenu()
  filter1 = gtk.RadioButton(None, _("Kaikki"))
  filter1.set_mode(False)
  filter1.connect("clicked", set_display_filter, (ALL, column))
  menu.add_filter(filter1)
  filter2 = gtk.RadioButton(filter1, _("Uudet"))
  filter2.set_mode(False)
  filter2.connect("clicked", set_display_filter, (NEW, column))
  menu.add_filter(filter2)
  filter3 = gtk.RadioButton(filter1, _("Ladatut"))
  filter3.set_mode(False)
  filter3.connect("clicked", set_display_filter, (LOADED, column))
  menu.add_filter(filter3)
  m_auth = gtk.Button(_("Kayttooikeus"))
  m_auth.connect("clicked", show_auth_dialog)
  menu.append(m_auth)
  m_dir = gtk.Button(_("Talletushakemisto"))
  m_dir.connect("clicked", show_dir_dialog, column)
  menu.append(m_dir)
  format_selector = hildon.TouchSelector()
  values = gtk.ListStore(gobject.TYPE_STRING)
  for item in format_list :
    display, format, bitrate = item
    new_iter = values.append()
    values.set(new_iter, 0, display)
  format_selector.append_text_column(values, True)
  format_selector.set_active(0, selected_format)
  format_selector.connect("changed", set_format, column)
  m_format = hildon.PickerButton(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
  m_format.set_title("Tiedostomuoto")
  m_format.set_selector(format_selector)
  menu.append(m_format)
  menu.show_all()
  win.set_app_menu(menu)
  win.add(column)
  win.connect("destroy", gtk.main_quit, None)
  win.show_all()
  gtk.main_iteration()
  feeds = get_and_clean_show_info(False)
  if len(feeds) > 0 :
    create_selector(column)
  filters = [ filter1, filter2, filter3 ]
  filter_state = filters[display_filter]
  filter_state.clicked()

if __name__ == "__main__":
  main()
  gtk.main()