import gtk
import hildondesktop
import hildon
import gobject
import dbus
from collections import deque
from dbus.mainloop.glib import DBusGMainLoop

import sys
f=open('/tmp/mylog.log', 'at', buffering=1)
sys.stdout=f
sys.stderr=f

class PlayerControl():
    def __init__(self):
        MAFW_OBJECT = 'com.nokia.mafw.renderer.Mafw-Gst-Renderer-Plugin.gstrenderer'
        MAFW_PATH = '/com/nokia/mafw/renderer/gstrenderer'
        MAFW_INTF = 'com.nokia.mafw.renderer' 
        session_bus = dbus.SessionBus(mainloop=DBusGMainLoop(set_as_default=True))
        mafw_object = session_bus.get_object(MAFW_OBJECT, MAFW_PATH)
        self.mafw_if = dbus.Interface(mafw_object, MAFW_INTF)

    def nexttrack(self):
        self.mafw_if.next()

    def isplaying(self):
        if self.mafw_if.get_status()[2] == 1:
            return True
        return False

    def on_state_changed(self, func):
        self.mafw_if.connect_to_signal("state_changed", func)


def getAverage(t_array):
    total = 0
    for i in t_array:
        total = total + i
    return total/len(t_array)


def getPositions():
    f = open("/sys/class/i2c-adapter/i2c-3/3-001d/coord", 'r' )
    coords = [int(w) for w in f.readline().split()]
    f.close()
    return coords


class HelloHomePlugin(hildondesktop.HomePluginItem):
    def __init__(self):
        hildondesktop.HomePluginItem.__init__(self)
        self.button = gtk.Button("Start")
        self.button.connect("clicked", self.startstoptimer)
        self.button.show_all()
        self.add(self.button)

        self.pc = PlayerControl()
        self.pc = PlayerControl()
        self.isactive = False
        self.flag = False
        self.x = deque([getPositions()[0] for i in range(10)])
        self.px = self.x[0]
        self.pc.on_state_changed(self.player_state_changed)
        if not self.pc.isplaying():
            self.button.set_sensitive(False)

    def timerloop(self):
        coords = getPositions()
        xx = self.px+(coords[0]-self.px)*0.1;
        self.x.append(xx)
        self.x.popleft()
        if not self.flag:
            if abs(xx - getAverage(self.x)) > 130:
                print "ca bouge"
                self.pc.nexttrack()
                self.flag = True
        else:
            if abs(xx - getAverage(self.x)) < 30:
                #Retour a la normale
                self.flag = False
        self.px = xx
        return self.isactive
    

    def startstoptimer(self, data):
        if self.isactive:
            print 'desactivation'
            self.button.set_label("Start")
            self.isactive = False
            return
        else:
            print 'activation'
            self.x = deque([getPositions()[0] for i in range(10)])
            self.px = self.x[0]
            gobject.timeout_add(200, self.timerloop)
            self.isactive = True
            self.button.set_label("Stop")


    def player_state_changed(self, data):
        """ 0 - Stopped
            1 - Playing
            2 - Paused
            3 - Transitioning
        """
        print "State changed"
        if (data == 0) or (data == 2):
            print "arret"
            self.startstoptimer(None)
            self.button.set_sensitive(False)
            return
        self.button.set_sensitive(True)
        


hd_plugin_type = HelloHomePlugin
if __name__ == "__main__":
    import gobject
    gobject.type_register(hd_plugin_type)
    obj = gobject.new(hd_plugin_type, plugin_id="plugin_id")
    obj.show_all()
    gtk.main()

