# -*- coding: utf-8 -*-
from PyQt4.Qt import Qt, pyqtSignal
from PyQt4.QtGui import QListView
from PyQt4.QtCore import QModelIndex, QTimer, QThread, QAbstractListModel
from common import CustomWindow
from components.model import ComponentListModel
from files.view import FilesView

class ComponentListViewThread(QThread):
    finishFetch = pyqtSignal(QAbstractListModel)
    def run(self):
        target = self.parent()
        listmodel = ComponentListModel(project = target.project, parent=None)
        listmodel.moveToThread(target.thread())
        listmodel.setParent(self)
        self.finishFetch.emit(listmodel)

class ComponentListView(CustomWindow):
    def __init__(self, parent=None, project=None):
        CustomWindow.__init__(self, parent, title=u"Loading components...")
        self.project = project
        self.listview = QListView(self)
        self.listview.setProperty("FingerScrollable", True)
        self.setCentralWidget(self.listview)
        self.fetchThread = ComponentListViewThread(self)
        self.fetchThread.finishFetch.connect(self.finishFetch)
        self.fetchThread.start()

    def finishFetch(self, listmodel):
        self.listmodel = listmodel
        self.listview.setModel(listmodel)
        self.listview.clicked.connect(self.openComponent)
        self.toggleBusy(False)
        self.setWindowTitle(u"Components of %s" % self.project.title)
        self.listview.setFocus()


    def openComponent(self, index):
        model = self.listmodel.data(index)
        win = FilesView(self, self.project, model)
        win.show()
