# -*- coding: utf-8 -*-

from PyQt4.QtCore import pyqtSignal, QObject
try:
    import simplejson as json
except ImportError:
    import json
import os
import time

class Config(QObject):
    bookmarksChanged = pyqtSignal()
    
    def __init__(self, filename="~/.config/transifex-client.json", autosave=True, parent=None):
        QObject.__init__(self, parent=parent)
        self.path = os.path.expanduser(filename)
        self.bookmarks = []
        try:
            raw = open(self.path, "ru").read()
            self.data = json.loads(raw)
        except (IOError, ValueError):
            self.data = {
                'latest_files' : [],
            }
        if not 'servers' in self.data:
            self.data['servers'] = {}
        self.autosave = autosave

    def add_server(self, hostname, username=None, password=None):
        self.data['servers'][hostname] = {
            'username':username,
            'password':password }


    def save(self):
        fh = open(self.path, "wu")
        fh.write(json.dumps(self.data))
        fh.close()

config = Config()

