# -*- coding: utf-8 -*-

import polib
polib.POEntry.fuzzy = lambda self: 'fuzzy' in self.flags
from PyQt4.QtGui import QIcon
from PyQt4.QtCore import QAbstractTableModel, QSize, Qt,\
    QAbstractListModel, QVariant

from common import IconCache, CustomWindow

import urllib, sys
import simplejson as json
import time
import logging

logger = logging.getLogger("gettextfile.model")

def google_translate(src, to, phrase):
    url = "http://ajax.googleapis.com/ajax/services/language/translate"
    args = {
        'v' : '1.0',
        'langpair': '%s|%s' % (src, to),
        'q': phrase,
    }
    body =  urllib.urlencode(args)
    logger.debug("Google Translate via %s?%s" % (url, body))
    resp = json.load(urllib.urlopen(url, body))
    try:
        return resp['responseData']['translatedText'].replace('&quot;', '\'')
    except:
        return phrase


class GettextFile(QAbstractTableModel):
    """
    Model for string set
    """
    HEADER = ['#','Source string', 'Translation']
    
    ICON_FLAG_GREEN = None
    ICON_FLAG_BLUE = None
    ICON_FLAG_RED = None

    def __init__(self, fp, parent = None):
        QAbstractTableModel.__init__(self, parent)
        self.file_model = fp
        logger.debug("Loading %s" % fp.local_path)
        self.objs = polib.pofile(fp.local_path)
        self.indexes = []
        for index in range(1, len(self.objs)+1):
            self.indexes.append(QVariant(u"%i" % index))
        self.size = QSize(300, 32)
        self.ICON_FLAG_GREEN = IconCache.getGreenFlag()
        self.ICON_FLAG_BLUE = IconCache.getBlueFlag()
        self.ICON_FLAG_RED = IconCache.getRedFlag()


    def headerData(self, section, orientation, role=Qt.DisplayRole):
        if orientation == Qt.Horizontal:
            if role == Qt.DisplayRole:
                try:
                    return self.HEADER[section]
                except IndexError:
                    pass
        return None

    def save(self, last_translator=None):
        if not last_translator:
            last_translator = "Invalid Username <invalid@transifex.net>"

        #self.objs.metadata['Project-Id-Version'] = '1.0'
        #self.objs.metadata['Report-Msgid-Bugs-To'] = 'python-polib@googlegroups.com'

        now = time.strftime('%Y-%m-%d %H:%M%z')
        #self.objs.metadata['POT-Creation-Date'] = now
        self.objs.metadata['PO-Revision-Date'] = now
        if self.objs.metadata['Last-Translator'] == "FULL NAME <EMAIL@ADDRESS>":
                self.objs.metadata['Last-Translator'] = last_translator
        if self.objs.metadata['Language-Team'] == "LANGUAGE <LL@li.org>":
                self.objs.metadata['Language-Team'] = last_translator
        self.objs.metadata['MIME-Version'] = '1.0'
        self.objs.metadata['Content-Type'] = 'text/plain; charset=utf-8'
        self.objs.metadata['Content-Transfer-Encoding'] = '8bit'
        logger.debug(u"PO-file metadata: %s" % self.objs.metadata)
        self.objs.save()

    def rowCount(self, parent):
        return len(self.objs)

    def columnCount(self, parent):
        return 3

    def autotranslate(self, index):
        entry = self.objs[index.row()]
        entry.msgstr = \
          google_translate('en', self.file_model.lang_code,
            entry.msgid)
        logger.debug("translate.google.com translated %s to %s" % (entry.msgid, entry.msgstr))

    def copysource(self, index):
        entry = self.objs[index.row()]
        entry.msgstr = entry.msgid

    def data(self, index, role):
        if not index.isValid() or index.row()<0 or index.row()>=len(self.objs):
            return None
        entry = self.objs[index.row()]
        column = index.column()
        if role == Qt.SizeHintRole:
            if column in [1,2]:
                return self.size
        elif role == Qt.DisplayRole:
            if column == 0:
                return self.indexes[index.row()]
            elif column == 1:
                return entry.msgid[:30] #.replace('\n',' ').strip()
            elif column == 2:
                return entry.msgstr[:30] #.replace('\n',' ').strip()
        elif role == -2: # Fiter role
            try:
                return entry.filter_data
            except AttributeError:
                entry.filter_data = "%s|%s" % (entry.msgid.lower(), entry.msgstr.lower())
            return entry.filter_data
        elif role == Qt.DecorationRole:
            if column != 0:
                return None
            elif entry.translated():
                return self.ICON_FLAG_GREEN
            elif entry.fuzzy():
                return self.ICON_FLAG_BLUE
            else:
                return self.ICON_FLAG_RED
        elif role == Qt.UserRole:
            return self.objs[index.row()]
        return None