# -*- coding: utf-8 -*-

class TranslationString:
    pass

class StringsManager(QAbstractListModel):
    """
    Model for string set
    """
    def __init__(self, project_slug, resource_slug, parent = None, client=None):
        QAbstractListModel.__init__(self, parent)
        self.objs = []
        res = client.pullStrings(project_slug, resource_slug)
        for d in res:
            p = Resource(slug = d['slug'], name = d['name'])
            self.objs.append(p)
            
    def rowCount(self, parent):
        return len(self.objs)

    def data(self, index, role):
        if not index.isValid():
            return QVariant()
        if index.row() < 0 or index.row() >= len(self.objs):
            return QVariant()
        if role == Qt.DisplayRole:
            return self.objs[index.row()].name
        if role == Qt.UserRole:
            return self.objs[index.row()]
        return QVariant()
            

    def headerData(self, section, orientation, role):
        if role != Qt.DisplayRole:
            return QVariant()
        return QString("String")
