# -*- coding: utf-8 -*-

from PyQt4.QtCore import QThread, Qt
from PyQt4.QtGui import QMainWindow, QWidget, QIcon,\
    QApplication
import os, sys
import logging

logger = logging.getLogger("common")

class CustomWindow(QMainWindow):
    def __init__(self, parent=None, title="Transifex-mobile", busy=True,
        skip_central_widget=False, delete_on_close=True):
        QMainWindow.__init__(self, parent)
        self.busy = busy
        if title:
            self.setWindowTitle(title)
        self.resize(800, 600)
        try:
            self.setAttribute(Qt.WA_Maemo5StackedWindow)
        except AttributeError:
            pass
        if not skip_central_widget:
            self.setCentralWidget(QWidget())
        if delete_on_close:
            self.setAttribute(Qt.WA_DeleteOnClose)
        self.fetchThread = None
        self.setWindowIcon(IconCache.get("apps/transifex.png"))

    def toggleBusy(self, checkState):
        try:
            self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, checkState)
        except AttributeError:
            self.setCursor(checkState and Qt.BusyCursor or Qt.ArrowCursor)

    def show(self):
        desktop = QApplication.desktop()
        x = (desktop.width()-self.width())/2
        y = (desktop.height()-self.height())/2-50
        self.move(x,y)
        QMainWindow.show(self)
        if self.busy:
            self.toggleBusy(True)

    def keyPressEvent(self, e):
        if e.key() == Qt.Key_Escape:
            self.close()
        else:
            QMainWindow.keyPressEvent(self, e)

    def closeEvent(self, event):
        if self.fetchThread:
            self.fetchThread.wait()
            event.accept()

class IconCache:
    """
    Puts loaded icons to in-memory cache to speed up and reduce memory usage
    """    
    prefix = "/usr/share/icons/hicolor/48x48"    
    cache = {}
    @classmethod
    def get(self, path):
        if path in self.cache:
            return self.cache[path]
        else:
            logger.debug("Loading icon: %s" % path)
            icon = QIcon(os.path.join(self.prefix, path))
            self.cache[path] = icon
            return icon
            
    @classmethod
    def getLocked(self):
        return self.get("hildon/general_locked.png")
        
    @classmethod
    def getUnlocked(self):
        return self.get("hildon/general_unlock.png")

    @classmethod
    def getSearch(self):
        return self.get("hildon/general_search.png")

    @classmethod    
    def getRedFlag(self):
        return self.get("hildon/calendar_colors_red.png")
        
    @classmethod    
    def getGreenFlag(self):
        return self.get("hildon/calendar_colors_green.png")
        
    @classmethod    
    def getBlueFlag(self):
        return self.get("hildon/calendar_colors_blue.png")
