# -*- coding: utf-8 -*-
from PyQt4.Qt import Qt, pyqtSignal
from PyQt4.QtGui import QListView
from PyQt4.QtCore import QModelIndex, QThread, QAbstractListModel
from common import QCustomWindow, QThreadedFunction
from projects.model import ProjectListModel
from components.view import ComponentListView
from views.search_string import SearchStringDialog

class ProjectsViewThread(QThread):
    finishFetch = pyqtSignal(QAbstractListModel)
    def __init__(self, search=None, parent=None):
        QThread.__init__(self, parent=parent)
        self.search = search

    def run(self):
        target = self.parent()
        listmodel = ProjectListModel(target.instance, search=self.search, parent=None)
        listmodel.moveToThread(target.thread())
        listmodel.setParent(target)
        self.finishFetch.emit(listmodel)

class ProjectsView(QCustomWindow):
    def openSearchDialog(self):
        term = SearchStringDialog.getSearchString(title="Search project")
        if term:
            for i in self.listview, self.actionSearch: i.setEnabled(False)
            self.fetchThread = ProjectsViewThread(search=term, parent=self)
            self.fetchThread.finishFetch.connect(self.finishFetch)
            self.fetchThread.start()
            
        
    def __init__(self, parent=None, instance=None):
        QCustomWindow.__init__(self, parent, title=u"Loading projects...")
        self.instance = instance
        print "ProjectsView(parent=%s, instance=%s)" % (parent, instance)
        self.listview = QListView(self)
        self.listview.setProperty("FingerScrollable", True)
        self.listview.clicked.connect(self.openProject)
        self.setCentralWidget(self.listview)
        self.projects = None
        self.actionSearch = self.menuBar().addAction(self.tr("&Search"), self.openSearchDialog)
        for i in self.listview, self.actionSearch: i.setEnabled(False)
        self.fetchThread = ProjectsViewThread(parent=self)
        self.fetchThread.finishFetch.connect(self.finishFetch)
        self.fetchThread.start()
        
    def finishFetch(self, listmodel):
        print " :: :: finishFetch(listmodel=%s)" % listmodel
        listmodel.setParent(self)
        self.listmodel = listmodel
        self.listview.setModel(listmodel)
        
        
        self.setWindowTitle(u"Projects at %s" % self.instance.title)
        self.toggleBusy(False)
        for i in self.listview, self.actionSearch: i.setEnabled(True)
        
    def openProject(self, index):
        project = self.listmodel.data(index)
        win = ComponentListView(self, project)
        win.show()