# -*- coding: utf-8 -*-
from PyQt4.Qt import Qt, pyqtSignal
from PyQt4.QtGui import QListView
from PyQt4.QtCore import QModelIndex, QTimer, QThread, QAbstractListModel
from common import QCustomWindow, QThreadedFunction
from components.model import ComponentListModel
from files.model import FileListModel
from gettextfile.view import FileView
from config import config

class FileListViewThread(QThread):
    finishFetch = pyqtSignal(QAbstractListModel)
    def run(self):
        target = self.parent()
        listmodel = FileListModel(project = target.project, component = target.component, parent=None)
        listmodel.moveToThread(target.thread())
        listmodel.setParent(self)
        self.finishFetch.emit(listmodel)

class FilesView(QCustomWindow):
    def __init__(self, parent=None, project=None, component=None):
        QCustomWindow.__init__(self, parent, title=u"Loading files...")
        self.project = project
        self.component = component
        self.listview = QListView(self)
        self.listview.setProperty("FingerScrollable", True)
        self.setCentralWidget(self.listview)
        self.fetchThread = FileListViewThread(self)
        self.fetchThread.finishFetch.connect(self.finishFetch)
        self.fetchThread.start()

    def finishFetch(self, listmodel):
        self.listmodel = listmodel
        self.listview.setModel(listmodel)
        self.listview.clicked.connect(self.openFile)
        self.toggleBusy(False)
        self.setWindowTitle(u"Files of %s/%s" % (self.project.title, self.component.title))

    def openFile(self, index):
        remotefile = self.listmodel.data(index)
        config.bookmarkFile(remotefile)
        config.bookmarksChanged.emit()
        obj = FileView(parent=self, fp=remotefile)
        obj.show()