# -*- coding: utf-8 -*-

from PyQt4.QtGui import QDialog, QLineEdit, QPushButton, QHBoxLayout

class SearchStringDialog(QDialog):
    @classmethod
    def getSearchString(self, default=None):
        d = SearchStringDialog()
        s = None
        if d.exec_():
            s = str(d.string.text())
        del d
        return s
        
    def __init__(self, parent=None):
        QDialog.__init__(self, parent)
        self.setWindowTitle("Search string")
        self.setModal(True)
        self.resize(300,0)
        self.string = QLineEdit()
        self.string.setCompleter(None)
        self.button = QPushButton("Search")
        self.button.clicked.connect(self.accept)
        
        layout = QHBoxLayout()
        layout.addWidget(self.string)
        layout.addWidget(self.button)

        self.setLayout(layout)
