# -*- coding: utf-8 -*-

from PyQt4.QtCore import QThread, Qt
from PyQt4.QtGui import QMainWindow, QWidget, QIcon,\
    QApplication
import os, sys



class QCustomWindow(QMainWindow):
    def __init__(self, parent=None, title="Transifex-mobile", busy=True,
        skip_central_widget=False, delete_on_close=True):
        QMainWindow.__init__(self, parent)
        self.busy = busy
        if title:
            self.setWindowTitle(title)
        self.resize(800, 600)
        try:
            self.setAttribute(Qt.WA_Maemo5StackedWindow)
        except AttributeError:
            pass
        if not skip_central_widget:
            self.setCentralWidget(QWidget())
        if delete_on_close:
            self.setAttribute(Qt.WA_DeleteOnClose)
        self.fetchThread = None
        self.setWindowIcon(QIconCache.get("tx16.png"))

    def toggleBusy(self, checkState):
        try:
            self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, checkState)
        except AttributeError:
            self.setCursor(checkState and Qt.BusyCursor or Qt.ArrowCursor)

    def show(self):
        desktop = QApplication.desktop()
        x = (desktop.width()-self.width())/2
        y = (desktop.height()-self.height())/2-50
        self.move(x,y)
        QMainWindow.show(self)
        if self.busy:
            self.toggleBusy(True)

    def keyPressEvent(self, e):
        if e.key() == Qt.Key_Escape:
            self.close()
        else:
            QMainWindow.keyPressEvent(self, e)

    def closeEvent(self, event):
        if self.fetchThread:
            self.fetchThread.wait()
            event.accept()

class QIconCache:
    """
    Puts loaded icons to in-memory cache to speed up and reduce memory usage
    """
    prefix = os.path.realpath(os.path.join(os.path.dirname(__file__), 'icons'))
    cache = {}
    @classmethod
    def get(self, path):
        if path in self.cache:
            return self.cache[path]
        else:
            print " :: Loading icon: %s" % path
            icon = QIcon(os.path.join(self.prefix, path))
            self.cache[path] = icon
            return icon
            
    @classmethod
    def preload(self):
        for filename in os.listdir(self.prefix):
            if filename.endswith('.svgz'):
                print " :: Preloading icon: %s" % filename
                self.get(filename)

def QThreadedFunction(target, args=(), callback=None, parent=None):
    class Thread(QThread):
        def run(self):
            target(*args)
            if callback:
                callback()
    thread = Thread(parent)
    thread.start()
    return thread