#!/usr/bin/python

from PyQt4 import QtGui, QtCore

platform = "Maemo5"
try:
   from PyQt4 import QtMaemo5
except:
   platform = "Windows"
   
class TimePicker(QtGui.QWidget):
   def __init__(self, parent=None):
      super(TimePicker, self).__init__()
      global platform
      
      if platform=="Maemo5":
         self.widget = QtMaemo5.QMaemo5ValueButton(self)
         self.pick = QtMaemo5.QMaemo5TimePickSelector()
         self.widget.setPickSelector(self.pick)
      else:
         self.widget = QtGui.QTimeEdit(self)
         self.widget.setDisplayFormat("HH:mm")
         
      self.vbox = QtGui.QVBoxLayout()
      self.vbox.addWidget(self.widget)
      self.setLayout(self.vbox)
      
   def setTime(self, time):
      global platform
      if platform=="Maemo5":
         self.pick.setCurrentTime(time)
      else:
         self.widget.setTime(time)

   def time(self):
      global platform
      if platform=="Maemo5":
         return self.pick.currentValueText()
      else:
         return self.widget.time().toString("HH:mm")

