#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys, sqlite3, os
from utils.DebugLog import DebugLog
from utils.Config import TrainTrainConf
from PyQt4 import QtCore, QtGui
from PyQt4.QtCore import Qt
from PyQt4.QtGui import QApplication

class SettingsDlg(QtGui.QDialog ):
   def __init__(self):
      QtGui.QDialog.__init__(self)

      self.conf = TrainTrainConf()

      self.CreateLayouts()
      self.setModal(True)
      self.setWindowTitle(u'Paramètres')

   def CreateLayouts(self):
      hLayout = QtGui.QHBoxLayout()
      labelnb = QtGui.QLabel('Nombre de trains par trajet')
      self.editnb = QtGui.QLineEdit()
      self.editnb.setText('%d'%self.conf.nbTrains())
      hLayout.addWidget(labelnb) 
      hLayout.addWidget(self.editnb)

      vbox = QtGui.QVBoxLayout()
      vbox.addLayout(hLayout)

      hLayout3 = QtGui.QHBoxLayout()
      buttons = QtGui.QDialogButtonBox()
      buttons.setStandardButtons(QtGui.QDialogButtonBox.Cancel|QtGui.QDialogButtonBox.Ok)
      self.connect(buttons, QtCore.SIGNAL("accepted()"), self.OnOK)
      self.connect(buttons, QtCore.SIGNAL("rejected()"), self.OnCancel)

      hLayout3.addWidget(buttons)
      vbox.addLayout(hLayout3)

      self.setLayout(vbox)

   def OnOK(self):
      nb = self.editnb.text()
      self.conf.WriteConfig(nb)
      self.accept()

   def OnCancel(self):
      self.reject()
