﻿#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys, sqlite3
from DebugLog import DebugLog
from ConfFile import RidesConfig, ConfFile, Ride
from PyQt4 import QtCore, QtGui
from PyQt4.QtCore import Qt
from PyQt4.QtGui import QApplication, QCompleter, QLineEdit, QComboBox, QStringListModel

class Completer(QCompleter):
   def __init__(self, parent=None):
      super(Completer,self).__init__(parent)
      model = QStringListModel()
      self.setModel(model)
      self.stringlist=QtCore.QStringList()

   def setStringList(self, stringlist):
      self.stringlist=stringlist
      self.model().setStringList(stringlist)

   def Filter(self, completionText):
      filtered=self.stringlist.filter(completionText,Qt.CaseInsensitive)
      self.model().setStringList(filtered)

class LineEdit(QLineEdit):
   def __init__(self, c, parent=None):
      super(LineEdit,self).__init__(parent)
      self.cmp=None
      self.c = c

   def setCompleter(self,completer):
      if self.cmp:
         self.disconnect(self.cmp,0,0)
      self.cmp=completer
      self.cmp.setWidget(self)
      self.cmp.setCompletionMode(QCompleter.PopupCompletion)
      self.cmp.setCaseSensitivity(Qt.CaseInsensitive)
      self.connect(self.cmp, QtCore.SIGNAL('activated(QString)'),self.insertCompletion)

   def insertCompletion(self,string):
      self.setText(string)

   def mousePressEvent(self, e):
      self.ShowCompletion()

   def keyPressEvent(self,e):
      if e.key() in (Qt.Key_Enter,Qt.Key_Return,Qt.Key_Escape,Qt.Key_Tab,Qt.Key_Backtab,Qt.Key_Alt):
         e.ignore()
         return

      super(LineEdit, self).keyPressEvent(e)

      if e.text():
         self.cmp.Filter( self.text() )

      self.ShowCompletion()

   def ShowCompletion(self):
      cr = self.childrenRect()
      self.cmp.complete(cr)

class SettingsDlg(QtGui.QDialog ):

   def __init__(self, garesConf):
      QtGui.QDialog.__init__(self)

      self.garesConf = garesConf
      self.CreateLayouts()
      #self.ReadConfig()
      self.added = None
      self.setModal(True)

   def UpdateCompleter2(self, gareName):
      # With station name, we look for station on same line
      self.c.execute('SELECT gares.rowid, name, ligne, exploitant, position FROM gares,lignes WHERE name="%s" AND gares.rowid=lignes.gareid'%gareName)
      lignes=[]
      for row in self.c:
         lignes.append( (row[2], row[3]) )

      req=''
      for lig, exp in lignes:
         if req:
            req += ' OR '
         req += '(lignes.ligne="%s"'%lig
         req += ')'

      if req:
         req = 'AND (%s)'%req

      # Get station that are on same line
      request = 'SELECT name FROM gares,lignes WHERE gares.rowid=lignes.gareid AND name<>"%s" %s GROUP BY name ORDER BY name'%(gareName, req)
      DebugLog(request)
      self.c.execute(request)
      gares=QtCore.QStringList()
      for row in self.c:
         gares << row[0]

      self.completer2.setStringList(gares)

   def CreateLayouts(self):
      list = QtCore.QStringList()

      conn = sqlite3.connect('datas/tec.sqlite')
      c = conn.cursor()
      self.c = c
      c.execute('SELECT * FROM gares ORDER BY name')

      for row in c:
         list << row[0]

      completer = Completer()
      completer.setStringList(list)

      self.completer2 = Completer()
      self.completer2.setStringList(list)

      self.editD = LineEdit(c)
      self.editD.setCompleter(completer)
      self.connect(completer, QtCore.SIGNAL('activated(QString)'), self.editD.insertCompletion)
      self.connect(completer, QtCore.SIGNAL('activated(QString)'), self.UpdateCompleter2)

      self.editA = LineEdit(c)
      self.editA.setCompleter(self.completer2)

      c.close()

      labelD = QtGui.QLabel()
      labelD.setText("Depart")
      labelA= QtGui.QLabel()
      labelA.setText(u"Arrivee")

      # lignesList = QtCore.QStringList()
      # lignesList << 'Tous' << 'RER A' << 'RER B' << 'RER C' << 'RER D' << 'RER E'
      # ligneD = QtGui.QComboBox()
      # ligneD.addItems( lignesList )
      # ligneA = QtGui.QComboBox()
      # ligneA.addItems( lignesList )

      hLayout1 = QtGui.QHBoxLayout()
#      hLayout1.addWidget(ligneD)
      hLayout1.addWidget(self.editD)

      hLayout2 = QtGui.QHBoxLayout()
 #     hLayout2.addWidget(ligneA)
      hLayout2.addWidget(self.editA)

      vbox = QtGui.QVBoxLayout()
      vbox.addWidget(labelD)

      vbox.addLayout(hLayout1)
      vbox.addWidget(labelA)
      vbox.addLayout(hLayout2)

      hLayout3 = QtGui.QHBoxLayout()
      buttons = QtGui.QDialogButtonBox()
      buttons.setStandardButtons(QtGui.QDialogButtonBox.Cancel|QtGui.QDialogButtonBox.Ok)
      self.connect(buttons, QtCore.SIGNAL("accepted()"), self.OnOK)
      self.connect(buttons, QtCore.SIGNAL("rejected()"), self.OnCancel)

      hLayout3.addWidget(buttons)
      vbox.addLayout(hLayout3)

      self.setLayout(vbox)

   def ReadConfig(self):
      self.garesConf.ReadRides()

   def WriteConfig(self):
      self.garesConf.WriteRides()

   def AddTrajet(self, depart, arrivee):
      if not depart:
         raise RuntimeError("Gare de départ non renseignée")

      if not arrivee:
         raise RuntimeError("Gare d'arrivée non renseignée")

      self.c.execute("SELECT ligne, exploitant FROM gares, lignes WHERE gares.name='%s' AND gares.rowid=lignes.gareid" % depart)
      lignesD=[]
      for row in self.c:
         lignesD.append(row[0])

      print lignesD
      if len(lignesD)==0:
         print "Gare '%s' inconnue"%depart
         raise RuntimeError("Gare '%s' inconnue"%depart)

      self.c.execute("SELECT ligne, exploitant FROM gares, lignes WHERE gares.name='%s' AND gares.rowid=lignes.gareid" % arrivee)

      lignesA=[]
      for row in self.c:
         if row[0] in lignesD:
            ligne=row[0]
            lignesA.append(ligne)
            DebugLog("commun : "+ligne)
            break

      if len(lignesA)==0:
         print "Gare '%s' inconnue"%arrivee
         raise RuntimeError("Gare '%s' inconnue"%arrivee)

      DebugLog(str(lignesA))
      req="SELECT name, code, exploitant, position FROM gares, lignes WHERE gares.name='%s' AND gares.rowid=lignes.gareid AND ligne='%s'" % (depart, ligne)
      DebugLog(req)
      self.c.execute(req)
      res = self.c.fetchone()
      if not res:
         return False

      DebugLog("rer?metro? :"+str(res))
      tec = ''
      if ligne[0]=='M':
         tec = 'Metro'
      elif ligne[0]=='R':
         tec = 'RER'
      # elif ligne[0]=='B':
         # tec = 'Bus'
      else:
         raise RuntimeError('tec inconnu "%s"'%ligne)

      depart = res[0]
      codeDepart = res[1]
      exploitant = res[2]
      posDepart = 0
      posArrivee = 0

      if res[3]:
         posDepart = int(res[3])

      req = "SELECT name, code, position FROM gares, lignes WHERE gares.name='%s' AND gares.rowid=lignes.gareid AND ligne='%s'" % (arrivee, ligne)
      DebugLog(req)
      self.c.execute(req)
      res = self.c.fetchone()

      ligne = ligne[1:]
      arrivee = res[0]
      codeArrivee = res[1]
      if res[2]:
         posArrivee = int(res[2])

      if posDepart-posArrivee>0:
         direction = 'A'
      elif posDepart-posArrivee<0:
         direction = 'R'
      else:
         direction = ''

      DebugLog('posD=%d, posA=%d, dir=%s'%(posDepart, posArrivee, direction))

      l = Ride(ligne, tec, depart, arrivee, codeDepart, codeArrivee, exploitant, direction)
      self.garesConf.AddRide(l)
      return l

   def OnOK(self):
      try:
         self.added = self.AddTrajet( self.editD.text(), self.editA.text() )
         self.WriteConfig()
      except RuntimeError, e:
         u=unicode(str(e), 'utf-8')
         QtGui.QMessageBox.critical(self, u'Erreur', u )
      self.accept()

   def OnCancel(self):
      self.reject()
