#!/usr/bin/python
# -*- coding: utf-8 -*-

from DebugLog import DebugLog
from ConfigParser import ConfigParser
import sys, sqlite3

class ConfFile:
   def __init__(self, fichier):
      self.config = ConfigParser()
      self.config.read(fichier)

   def get(self, section, key):
      try:
         return self.config.get(section, key)
      except:
         return ''

class Ride:
   def __init__(self, ligne, tec, depart, arrivee, codeDepart, codeArrivee, exploitant, direction):
      self.ligne = ligne
      self.tec = tec
      self.depart = depart
      self.codeDepart = codeDepart
      self.arrivee = arrivee
      self.codeArrivee = codeArrivee
      self.exploitant = exploitant
      self.direction = direction

class RidesConfig:
   def __init__(self, filename):
      DebugLog("RidesConfig::__init__")
      self.rides=dict()
      self.hasChanged = False
      self.filename = filename

   def AddRide(self, ride, id=''):
      DebugLog("RidesConfig::AddRide")
      self.hasChanged = True
      if not id:
         id = 'Ride%d'%(len(self.rides)+1)
      self.rides[id] = ride
      ride.id = id

   def RemoveRide(self, id):
      DebugLog("RidesConfig::RemoveRide")
      del self.rides[id]
      self.hasChanged = True

   def GetRides(self):
      return sorted(self.rides.values(), reverse=True)

   def ReadRides(self):
      DebugLog("RidesConfig::ReadRides")
      self.rides=dict()
      t = ConfFile(self.filename)
      
      for section in t.config.sections():
         ligne = t.get(section, 'ligne')
         tec = t.get(section, 'tec')
         depart = t.get(section, 'depart')
         arrivee = t.get(section, 'arrivee')
         codeDepart = t.get(section, 'codeDepart')
         codeArrivee = t.get(section, 'codeArrivee')
         exploitant = t.get(section, 'exploitant')
         direction = t.get(section, 'direction')

         l = Ride(ligne, tec, depart, arrivee, codeDepart, codeArrivee, exploitant, direction)
         self.AddRide(l, section)
      self.hasChanged = False

   def Write(self):
      self.WriteRides()
      self.hasChanged = False

   def WriteRides(self):
      DebugLog("RidesConfig::WriteLignes(%s)"%self.filename)
      
      f = open(self.filename, 'w')
      t = ConfigParser()
      iride=1

      DebugLog("nb rides=%d"%len(self.rides.values()))
      
      for k in self.rides.keys():
         ride = self.rides[k]
         key=ride.id
         t.add_section(key)
         t.set(key, 'TEC', ride.tec)
         t.set(key, 'Ligne', ride.ligne)
         t.set(key, 'depart', ride.depart)
         t.set(key, 'arrivee', ride.arrivee)
         t.set(key, 'codeDepart', ride.codeDepart)
         t.set(key, 'codeArrivee', ride.codeArrivee)
         t.set(key, 'exploitant', ride.exploitant)
         if ride.direction:
            t.set(key, 'direction', ride.direction)
         iride += 1

      t.write(f)
