#include "tracker-ripped-functions.h"

#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

FILE *
tracker_file_open (const gchar *uri,
		   const gchar *how,
		   gboolean	sequential)
{
 	FILE     *file;
	gboolean  readonly;
	int       flags;

	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (how != NULL, NULL);

	file = fopen (uri, how);
	if (!file) {
		return NULL;
	}

 	/* Are we opening for readonly? */
	readonly = !strstr (uri, "r+") && strchr (uri, 'r');

	if (readonly) {
		int fd;

		fd = fileno (file);
		
#if defined(__linux__)
		/* Make sure we set the NOATIME flag if we have permissions to */
		if ((flags = fcntl (fd, F_GETFL, 0)) != -1) {
			fcntl (fd, F_SETFL, flags | O_NOATIME);
		}
#endif
	}
	
	return file;
}

void
tracker_file_close (FILE     *file,
		    gboolean  need_again_soon) 
{
	g_return_if_fail (file != NULL);

	fclose (file);
}
