﻿ ## This program is free software; you can redistribute it and/or modify
 ## it under the terms of the GNU General Public License as published
 ## by the Free Software Foundation; version 2 or any later version.
 ##
 ## This program is distributed in the hope that it will be useful,
 ## but WITHOUT ANY WARRANTY; without even the implied warranty of
 ## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ## GNU General Public License for more details.
 ##
lang_codes = ('en', 'da', 'nl', 'fi', 'fr', 'de', 'it', 'nb', 'pt', 'ru', 'es', 'sv')

contents = (\
('General', (
# Log Verbosity (0=errors, 1=minimal, 2=detailed, 3=debug)
  ('Verbosity', 'pickerbutton', ('0', '1', '2', '3'), '0'),
# Initial sleep time in seconds (0->1000)
  ('InitialSleep', 'textentry', '7'),
# Minimizes memory use at the expense of indexing speed
  ('LowMemoryMode', 'checkbutton', 'false'),
# Set to TRUE when the home directory is in a NFS filesystem
  ('NFSLocking', 'checkbutton', 'false')
)), 
('Watches', (
# List of directory roots to index and watch (separator=;)
  ('WatchDirectoryRoots', 'directories_button', '$HOME/MyDocs/.sounds/;$HOME/MyDocs/.documents/;$HOME/MyDocs/.videos/;$HOME/MyDocs/.images/;$HOME/MyDocs/.camera/;'),
# List of directory roots to index but NOT watch (separator=;)
  ('CrawlDirectory', 'directories_button', ''),
# List of directory roots NOT to index and NOT to watch (separator=;)
  ('NoWatchDirectory', 'directories_button', '$HOME/MyDocs/core-dumps/;$HOME/MyDocs/cities/;$HOME/MyDocs/.sounds/Ringtones/;$HOME/MyDocs/tmp/;/media/mmc1/tmp/;/media/mmc1/cities/;'),
# Set to false to completely disable any watching
  ('EnableWatching', 'checkbutton', 'true')
)),
('Indexing', (
# Sets the indexing speed (0->20, where 20=slowest speed)
  ('Throttle', 'seekbar', (0, 20), '0'),
# Set to false to completely disable any indexing
  ('EnableIndexing', 'checkbutton', 'true'),
# Set to false to completely disable file content indexing
  ('EnableFileContentIndexing', 'checkbutton', 'true'),
# Set to false to completely disable thumbnail generation
  ('EnableThumbnails', 'checkbutton', 'true'),
# List of disabled modules (separator=;)
# The modules that are indexed are kept in $prefix/lib/tracker/indexer-modules
  ('DisabledModules', 'stringlist_button', ''),
# Set to false to NOT hog the disk for extended periods
  ('FastMerges', 'checkbutton', 'false'),
# List of partial file pattern globs (separator=;)
# This is for files to NOT index
# (basic stat info is only extended for files that match the patterns)
  ('NoIndexFileTypes', 'stringlist_button', ''),
# Set the minimum length of words to index (0->30, default=3)
  ('MinWordLength', 'seekbar', (0, 30), '3'),
# Set the maximum length of words to index (0->200, default=30)
  ('MaxWordLength', 'seekbar', (0, 200), '30'),
# Set the language specific stemmer and stopword list to use
# Values include:
# - en (English)
# - da (Danish)
# - nl (Dutch)
# - fi (Finish)
# - fr (French)
# - de (German)
# - it (Italian)
# - nb (Norwegian)
# - pt (Portugese)
# - ru (Russian)
# - es (Spanish)
# - sv (Swedish)
  ('Language', 'pickerbutton', lang_codes, 'en'),
# Set to false to disable language specific stemmer
  ('EnableStemmer', 'checkbutton', 'true'),
# Set to true to disable indexing when running on battery
  ('BatteryIndex', 'checkbutton', 'false'),
# Set to true to disable initial indexing when running on battery
  ('BatteryIndexInitial', 'checkbutton', 'false'),
# Pause indexer when disk space is <= this value
# (0->100, value is in % of $HOME file system, -1=disable pausing)
  ('LowDiskSpaceLimit', 'seekbar', (-1, 100), '1'),
# Set to true to enable traversing mounted directories on other file systems
# (this excludes removable devices)
  ('IndexMountedDirectories', 'checkbutton', 'true'),
# Set to true to enable traversing mounted directories for removable devices
  ('IndexRemovableMedia', 'checkbutton', 'true'),
)),
('Performance', (
# Maximum text size in bytes to index from a file's content
  ('MaxTextToIndex', 'textentry', '1048576'),
# Maximum unique words to index from a file's content
  ('MaxWordsToIndex', 'textentry', '10000'),
  ('MinBucketCount', 'textentry', '32768'),
  ('MaxBucketCount', 'textentry', '65535'),
))
)