/*
 * This file is part of TpSession
 *
 * Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
 * Contact Kate Alhola  kate.alholanokia.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#ifndef TPSESSION_H
#define TPSESSION_H

#include <TelepathyQt4/Types>
#include <TelepathyQt4/Account>
#include <TelepathyQt4/Types>
#include <TelepathyQt4/PendingChannelRequest>
#include <TelepathyQt4/ChannelRequest>
#include <TelepathyQt4/PendingChannel>
#include <TelepathyQt4/Channel>
#include <TelepathyQt4/TextChannel>
#include <TelepathyQt4/AccountManager>
#include <TelepathyQt4/PendingOperation>
#include <TelepathyQt4/PendingReady>
#include <TelepathyQt4/ClientRegistrar>
#include <TelepathyQt4/Debug>

#include <QString>
#include <QVector>
#include <QObject>

#include "tpsessionaccount.h"
#include "tpsessionobserver.h"

class TpSession:public QObject
{
       Q_OBJECT
public:
    TpSession(QString cmname=QString(),bool synchronous=FALSE);


    static TpSession* instance(bool synchronous=TRUE);
    void sendMessageToAddress(QString connectionMgr,QString address,QString message);
    TpSessionAccount* getAccount(const  QString cm, const QString protocol=QString());
    void createChannelListener(const QString &channelType,
                               const Tp::MethodInvocationContextPtr<> &context,
                               const Tp::AccountPtr &account,
                               const Tp::ChannelPtr &channel);
    void createObserver();

signals:
    void amReady(TpSession *);
    void accountReady(TpSessionAccount *);
    void channeReady(TpSessionAccount *);
    void messageReceived(const Tp::ReceivedMessage &,TpSessionAccount *);
private slots:
    void onAMReady(Tp::PendingOperation *);
    void onAccountCreated(const QString &);
    void onReady(Tp::PendingOperation *);
    void onAccountReady(TpSessionAccount *tpacc);
    void onMessageReceived(const Tp::ReceivedMessage &,TpSessionAccount *);
public:
    QVector<TpSessionAccount*> accounts;

private:
    static TpSession *instancePtr;
    //TpSession *instancePtr;
    QString reqCm;
    QString reqAddress;
    QString reqMsg;

    bool sync;  // Synchronous initialization
    QEventLoop loop;
    Tp::AccountManagerPtr mAM;
    QStringList channels;
    Tp::ClientRegistrarPtr registrar;
};



#endif // TPSESSION_H
